/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.KotlinClassInfo;
import org.jetbrains.kotlin.incremental.storage.ClassIdExternalizer;
import org.jetbrains.kotlin.incremental.storage.ConstantExternalizer;
import org.jetbrains.kotlin.incremental.storage.IntExternalizer;
import org.jetbrains.kotlin.incremental.storage.LinkedHashMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.ListExternalizer;
import org.jetbrains.kotlin.incremental.storage.LongExternalizer;
import org.jetbrains.kotlin.incremental.storage.NullableValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringExternalizer;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/KotlinClassInfoExternalizer;", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "info", "incremental-compilation-impl"})
public final class KotlinClassInfoExternalizer
implements DataExternalizer<KotlinClassInfo> {
    @NotNull
    public static final KotlinClassInfoExternalizer INSTANCE = new KotlinClassInfoExternalizer();

    private KotlinClassInfoExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull KotlinClassInfo info) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(info, "info");
        ClassIdExternalizer.INSTANCE.save(output, info.getClassId());
        IntExternalizer.INSTANCE.save(output, info.getClassKind().getId());
        new ListExternalizer(StringExternalizer.INSTANCE).save(output, (Collection)ArraysKt.toList(info.getClassHeaderData()));
        new ListExternalizer(StringExternalizer.INSTANCE).save(output, (Collection)ArraysKt.toList(info.getClassHeaderStrings()));
        new NullableValueExternalizer<String>(StringExternalizer.INSTANCE).save(output, info.getMultifileClassName());
        new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, ConstantExternalizer.INSTANCE).save(output, (Map)info.getConstantsMap());
        new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, LongExternalizer.INSTANCE).save(output, (Map)info.getInlineFunctionsMap());
    }

    @Override
    @NotNull
    public KotlinClassInfo read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        ClassId classId = ClassIdExternalizer.INSTANCE.read(input);
        KotlinClassHeader.Kind kind = KotlinClassHeader.Kind.Companion.getById(IntExternalizer.INSTANCE.read(input));
        Object $this$toTypedArray$iv = new ListExternalizer(StringExternalizer.INSTANCE).read(input);
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull(stringArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        $this$toTypedArray$iv = new ListExternalizer(StringExternalizer.INSTANCE).read(input);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull(stringArray2, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return new KotlinClassInfo(classId, kind, stringArray, stringArray2, (String)new NullableValueExternalizer(StringExternalizer.INSTANCE).read(input), (LinkedHashMap)new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, ConstantExternalizer.INSTANCE).read(input), (LinkedHashMap)new LinkedHashMapExternalizer(StringExternalizer.INSTANCE, LongExternalizer.INSTANCE).read(input));
    }
}

