/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPublishedApiChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirPublishedApiChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirPublishedApiChecker INSTANCE = new FirPublishedApiChecker();

    private FirPublishedApiChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        if (declaration instanceof FirValueParameter) {
            return;
        }
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Internal.INSTANCE)) {
            return;
        }
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, StandardClassIds.Annotations.INSTANCE.getPublishedApi());
        if (firAnnotation == null) {
            return;
        }
        FirAnnotation annotation2 = firAnnotation;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getNON_INTERNAL_PUBLISHED_API(), (DiagnosticContext)context, null, 8, null);
    }
}

