/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.RemoteBuildMetricsReporter;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0001J\u0019\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u0019\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0096\u0001J\u0019\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0001J\b\u0010\u001c\u001a\u00020\nH\u0016J\t\u0010\u001d\u001a\u00020\u0014H\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/daemon/report/RemoteBuildMetricsReporterAdapter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/RemoteBuildMetricsReporter;", "delegate", "shouldReport", "", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;ZLorg/jetbrains/kotlin/daemon/common/CompilationResults;)V", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addMetric", "metric", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "value", "", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetricMs", "time", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "durationMs", "addTimeMetricNs", "durationNs", "endMeasure", "flush", "getMetrics", "startMeasure", "kotlin-daemon"})
public final class RemoteBuildMetricsReporterAdapter
implements BuildMetricsReporter,
RemoteBuildMetricsReporter {
    @NotNull
    private final BuildMetricsReporter delegate;
    private final boolean shouldReport;
    @NotNull
    private final CompilationResults compilationResults;

    public RemoteBuildMetricsReporterAdapter(@NotNull BuildMetricsReporter delegate2, boolean shouldReport, @NotNull CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        Intrinsics.checkNotNullParameter(compilationResults, "compilationResults");
        this.delegate = delegate2;
        this.shouldReport = shouldReport;
        this.compilationResults = compilationResults;
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        this.delegate.addAttribute(attribute);
    }

    @Override
    public void addMetric(@NotNull BuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        this.delegate.addMetric(metric, value2);
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics metrics) {
        Intrinsics.checkNotNullParameter(metrics, "metrics");
        this.delegate.addMetrics(metrics);
    }

    @Override
    public void addTimeMetricMs(@NotNull BuildTime time, long durationMs) {
        Intrinsics.checkNotNullParameter(time, "time");
        this.delegate.addTimeMetricMs(time, durationMs);
    }

    @Override
    public void addTimeMetricNs(@NotNull BuildTime time, long durationNs) {
        Intrinsics.checkNotNullParameter(time, "time");
        this.delegate.addTimeMetricNs(time, durationNs);
    }

    @Override
    public void endMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter(time, "time");
        this.delegate.endMeasure(time);
    }

    @Override
    @NotNull
    public BuildMetrics getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public void startMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter(time, "time");
        this.delegate.startMeasure(time);
    }

    @Override
    public void flush() {
        if (this.shouldReport) {
            BuildMetrics metrics = this.delegate.getMetrics();
            this.compilationResults.add(CompilationResultCategory.BUILD_METRICS.getCode(), metrics);
        }
    }
}

