/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Forceable;
import org.jetbrains.kotlin.com.intellij.util.io.DataEnumeratorEx;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentBTreeEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;

public class PersistentEnumeratorDelegate<Data>
implements Forceable,
DataEnumeratorEx<Data>,
Closeable {
    @NotNull
    protected final PersistentEnumeratorBase<Data> myEnumerator;

    @NotNull
    static <Data> PersistentEnumeratorBase<Data> createDefaultEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext, int version) throws IOException {
        if (file2 == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(8);
        }
        if (dataDescriptor == null) {
            PersistentEnumeratorDelegate.$$$reportNull$$$0(9);
        }
        return PersistentEnumeratorDelegate.useBtree() ? new PersistentBTreeEnumerator<Data>(file2, dataDescriptor, initialSize, lockContext, version) : new PersistentEnumerator<Data>(file2, dataDescriptor, initialSize, null, version);
    }

    @ApiStatus.Internal
    public static boolean useBtree() {
        String property2 = System.getProperty("idea.use.btree");
        return !"false".equals(property2);
    }

    @Override
    public void close() throws IOException {
        PersistentEnumeratorBase<Data> enumerator = this.myEnumerator;
        if (enumerator != null) {
            enumerator.close();
        }
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }

    @Override
    public void force() {
        this.myEnumerator.force();
    }

    @Override
    public Data valueOf(int id) throws IOException {
        return this.myEnumerator.valueOf(id);
    }

    @Override
    public int enumerate(Data name2) throws IOException {
        return this.myEnumerator.enumerate(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentEnumeratorDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultEnumerator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

