/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import org.jetbrains.kotlin.com.google.common.base.MoreObjects;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.internal.BindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalContext;
import org.jetbrains.kotlin.com.google.inject.internal.InternalFactory;
import org.jetbrains.kotlin.com.google.inject.internal.Scoping;
import org.jetbrains.kotlin.com.google.inject.spi.BindingTargetVisitor;
import org.jetbrains.kotlin.com.google.inject.spi.Dependency;
import org.jetbrains.kotlin.com.google.inject.spi.UntargettedBinding;

final class UntargettedBindingImpl<T>
extends BindingImpl<T>
implements UntargettedBinding<T> {
    UntargettedBindingImpl(InjectorImpl injector, Key<T> key, Object source) {
        super(injector, key, source, new InternalFactory<T>(){

            @Override
            public T get(InternalContext context, Dependency<?> dependency, boolean linked) {
                throw new AssertionError();
            }
        }, Scoping.UNSCOPED);
    }

    public UntargettedBindingImpl(Object source, Key<T> key, Scoping scoping) {
        super(source, key, scoping);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new UntargettedBindingImpl(this.getSource(), this.getKey(), scoping);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new UntargettedBindingImpl<T>(this.getSource(), key, this.getScoping());
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(binder.withSource(this.getSource()).bind(this.getKey()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(UntargettedBinding.class).add("key", this.getKey()).add("source", this.getSource()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UntargettedBindingImpl) {
            UntargettedBindingImpl o = (UntargettedBindingImpl)obj;
            return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKey(), this.getScoping());
    }
}

