/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCallGenerator;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/JvmInvokeDynamic;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "evalBootstrapArgumentIntrinsicCall", "", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "evalMethodHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "evalMethodType", "Lorg/jetbrains/org/objectweb/asm/Type;", "evalOriginalMethodType", "generateBootstrapMethodArg", "element", "Lorg/jetbrains/kotlin/ir/expressions/IrVarargElement;", "generateMethodHandle", "irRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "backend.jvm.codegen"})
public final class JvmInvokeDynamic
extends IntrinsicMethod {
    @NotNull
    public static final JvmInvokeDynamic INSTANCE = new JvmInvokeDynamic();

    private JvmInvokeDynamic() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        IrExpression irExpression;
        Handle bootstrapMethodHandle;
        IrSimpleFunction dynamicCallee;
        IrCall dynamicCall;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(codegen2, "codegen");
                Intrinsics.checkNotNullParameter(data2, "data");
                IrExpression irExpression2 = expression2.getValueArgument(0);
                IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
                if (irCall == null) {
                    JvmInvokeDynamic.invoke$fail(expression2, "'dynamicCall' is expected to be a call");
                    throw null;
                }
                dynamicCall = irCall;
                dynamicCallee = (IrSimpleFunction)dynamicCall.getSymbol().getOwner();
                if (!Intrinsics.areEqual(dynamicCallee.getParent(), codegen2.getContext().getIr().getSymbols().getKotlinJvmInternalInvokeDynamicPackage()) || !Intrinsics.areEqual(dynamicCallee.getOrigin(), JvmLoweredDeclarationOrigin.INVOKEDYNAMIC_CALL_TARGET.INSTANCE)) {
                    JvmInvokeDynamic.invoke$fail(expression2, "Unexpected dynamicCallee: '" + RenderIrElementKt.render(dynamicCallee) + '\'');
                    throw null;
                }
                IrExpression irExpression3 = expression2.getValueArgument(1);
                IrCall irCall2 = irExpression3 instanceof IrCall ? (IrCall)irExpression3 : null;
                if (irCall2 == null) {
                    JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodHandle' should be a call");
                    throw null;
                }
                IrCall bootstrapMethodHandleArg = irCall2;
                bootstrapMethodHandle = this.evalMethodHandle(bootstrapMethodHandleArg);
                irExpression = expression2.getValueArgument(2);
                if (irExpression == null) break block11;
                IrExpression $this$safeAs$iv = irExpression;
                boolean $i$f$safeAs = false;
                IrExpression irExpression4 = $this$safeAs$iv;
                if (!(irExpression4 instanceof IrVararg)) {
                    irExpression4 = null;
                }
                if ((irExpression = (IrVararg)irExpression4) != null) break block12;
            }
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodArgs' is expected to be a vararg");
            throw null;
        }
        IrExpression bootstrapMethodArgs = irExpression;
        Iterable iterable = ((IrVararg)bootstrapMethodArgs).getElements();
        boolean $i$f$map = false;
        void $i$f$safeAs = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.generateBootstrapMethodArg((IrVarargElement)it, codegen2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        Object[] asmBootstrapMethodArgs = objectArray;
        Method dynamicCalleeMethod = codegen2.getMethodSignatureMapper().mapAsmMethod(dynamicCallee);
        IrCallGenerator.DefaultCallGenerator dynamicCallGenerator = IrCallGenerator.DefaultCallGenerator.INSTANCE;
        Type[] dynamicCalleeArgumentTypes = dynamicCalleeMethod.getArgumentTypes();
        int n = dynamicCallee.getValueParameters().size();
        for (int i = 0; i < n; ++i) {
            IrExpression dynamicCalleeArgument;
            IrValueParameter dynamicCalleeParameter = dynamicCallee.getValueParameters().get(i);
            if (dynamicCall.getValueArgument(i) == null) {
                JvmInvokeDynamic.invoke$fail(expression2, "No argument #" + i + " in 'dynamicCall'");
                throw null;
            }
            Intrinsics.checkNotNullExpressionValue(dynamicCalleeArgumentTypes, "dynamicCalleeArgumentTypes");
            Type[] typeArray = dynamicCalleeArgumentTypes;
            if (i < 0 || i > ArraysKt.getLastIndex(typeArray)) {
                int it = i;
                boolean bl = false;
                JvmInvokeDynamic.invoke$fail(expression2, "No argument type #" + i + " in dynamic callee: " + dynamicCalleeMethod);
                throw null;
            }
            Type dynamicCalleeArgumentType = typeArray[i];
            Intrinsics.checkNotNullExpressionValue(dynamicCalleeArgumentType, "dynamicCalleeArgumentType");
            dynamicCallGenerator.genValueAndPut(dynamicCalleeParameter, dynamicCalleeArgument, dynamicCalleeArgumentType, codegen2, data2);
        }
        codegen2.getMv().invokedynamic(dynamicCalleeMethod.getName(), dynamicCalleeMethod.getDescriptor(), bootstrapMethodHandle, asmBootstrapMethodArgs);
        Type type2 = dynamicCalleeMethod.getReturnType();
        Intrinsics.checkNotNullExpressionValue(type2, "dynamicCalleeMethod.returnType");
        return new MaterialValue(codegen2, type2, expression2.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object generateBootstrapMethodArg(IrVarargElement element, ExpressionCodegen codegen2) {
        Object object;
        IrVarargElement irVarargElement = element;
        if (irVarargElement instanceof IrRawFunctionReference) {
            object = this.generateMethodHandle((IrRawFunctionReference)element, codegen2);
            return object;
        } else {
            if (irVarargElement instanceof IrCall) {
                object = this.evalBootstrapArgumentIntrinsicCall((IrCall)element, codegen2);
                if (object != null) return object;
                throw new AssertionError((Object)("Unexpected callee in bootstrap method argument:\n" + DumpIrTreeKt.dump$default(element, false, false, 3, null)));
            }
            if (!(irVarargElement instanceof IrConst)) throw new AssertionError((Object)("Unexpected bootstrap method argument:\n" + DumpIrTreeKt.dump$default(element, false, false, 3, null)));
            IrConstKind irConstKind = ((IrConst)element).getKind();
            if (Intrinsics.areEqual(irConstKind, IrConstKind.Byte.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Byte");
                object = (int)((Byte)t).byteValue();
                return object;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Short.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Short");
                object = (int)((Short)t).shortValue();
                return object;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Int.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Int");
                object = (Integer)t;
                return object;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Long.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Long");
                object = (Long)t;
                return object;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Float.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Float");
                object = (Float)t;
                return object;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Double.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Double");
                object = (Double)t;
                return object;
            } else {
                if (!Intrinsics.areEqual(irConstKind, IrConstKind.String.INSTANCE)) throw new AssertionError((Object)("Unexpected constant expression in bootstrap method argument:\n" + DumpIrTreeKt.dump$default(element, false, false, 3, null)));
                Object t = ((IrConst)element).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.String");
                object = (String)t;
            }
        }
        return object;
    }

    private final Object evalBootstrapArgumentIntrinsicCall(IrCall irCall, ExpressionCodegen codegen2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = irCall.getSymbol();
        return Intrinsics.areEqual(irSimpleFunctionSymbol, codegen2.getContext().getIr().getSymbols().getJvmOriginalMethodTypeIntrinsic()) ? this.evalOriginalMethodType(irCall, codegen2) : (Intrinsics.areEqual(irSimpleFunctionSymbol, codegen2.getContext().getIr().getSymbols().getJvmMethodType()) ? this.evalMethodType(irCall) : (Intrinsics.areEqual(irSimpleFunctionSymbol, codegen2.getContext().getIr().getSymbols().getJvmMethodHandle()) ? this.evalMethodHandle(irCall) : null));
    }

    private final Type evalMethodType(IrCall irCall) {
        String descriptor2 = JvmIrUtilsKt.getStringConstArgument(irCall, 0);
        Type type2 = Type.getMethodType(descriptor2);
        Intrinsics.checkNotNullExpressionValue(type2, "getMethodType(descriptor)");
        return type2;
    }

    private final Handle evalMethodHandle(IrCall irCall) {
        int tag = JvmIrUtilsKt.getIntConstArgument(irCall, 0);
        String owner = JvmIrUtilsKt.getStringConstArgument(irCall, 1);
        String name2 = JvmIrUtilsKt.getStringConstArgument(irCall, 2);
        String descriptor2 = JvmIrUtilsKt.getStringConstArgument(irCall, 3);
        boolean isInterface = JvmIrUtilsKt.getBooleanConstArgument(irCall, 4);
        return new Handle(tag, owner, name2, descriptor2, isInterface);
    }

    private final Handle generateMethodHandle(IrRawFunctionReference irRawFunctionReference, ExpressionCodegen codegen2) {
        return codegen2.getContext().getMethodSignatureMapper().mapToMethodHandle(irRawFunctionReference.getSymbol().getOwner());
    }

    private final Type evalOriginalMethodType(IrCall irCall, ExpressionCodegen codegen2) {
        IrExpression irExpression = irCall.getValueArgument(0);
        IrRawFunctionReference irRawFunctionReference = irExpression instanceof IrRawFunctionReference ? (IrRawFunctionReference)irExpression : null;
        if (irRawFunctionReference == null) {
            throw new AssertionError((Object)("Argument in " + ((IrSimpleFunction)irCall.getSymbol().getOwner()).getName() + " call is expected to be a raw function reference:\n" + DumpIrTreeKt.dump$default(irCall, false, false, 3, null)));
        }
        IrRawFunctionReference irRawFunRef = irRawFunctionReference;
        IrFunction irFun = irRawFunRef.getSymbol().getOwner();
        Method asmMethod2 = codegen2.getMethodSignatureMapper().mapAsmMethod(irFun);
        Type type2 = Type.getMethodType(asmMethod2.getDescriptor());
        Intrinsics.checkNotNullExpressionValue(type2, "getMethodType(asmMethod.descriptor)");
        return type2;
    }

    private static final Void invoke$fail(IrFunctionAccessExpression $expression, String message) {
        throw new AssertionError((Object)(message + "; expression:\n" + DumpIrTreeKt.dump$default($expression, false, false, 3, null)));
    }
}

