/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeSignatureMappingKt {
    @NotNull
    public static final <T> T boxTypeIfNeeded(@NotNull JvmTypeFactory<T> $this$boxTypeIfNeeded, @NotNull T possiblyPrimitiveType, boolean needBoxedType) {
        Intrinsics.checkNotNullParameter($this$boxTypeIfNeeded, "<this>");
        Intrinsics.checkNotNullParameter(possiblyPrimitiveType, "possiblyPrimitiveType");
        return needBoxedType ? $this$boxTypeIfNeeded.boxType(possiblyPrimitiveType) : possiblyPrimitiveType;
    }

    @Nullable
    public static final <T> T mapBuiltInType(@NotNull TypeSystemCommonBackendContext $this$mapBuiltInType, @NotNull KotlinTypeMarker type2, @NotNull JvmTypeFactory<T> typeFactory, @NotNull TypeMappingMode mode) {
        Intrinsics.checkNotNullParameter($this$mapBuiltInType, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(typeFactory, "typeFactory");
        Intrinsics.checkNotNullParameter(mode, "mode");
        TypeConstructorMarker constructor2 = $this$mapBuiltInType.typeConstructor(type2);
        if (!$this$mapBuiltInType.isClassTypeConstructor(constructor2)) {
            return null;
        }
        PrimitiveType primitiveType = $this$mapBuiltInType.getPrimitiveType(constructor2);
        if (primitiveType != null) {
            T jvmType = typeFactory.createPrimitiveType(primitiveType);
            boolean isNullableInJava = $this$mapBuiltInType.isNullableType(type2) || TypeEnhancementUtilsKt.hasEnhancedNullability($this$mapBuiltInType, type2);
            return TypeSignatureMappingKt.boxTypeIfNeeded(typeFactory, jvmType, isNullableInJava);
        }
        PrimitiveType arrayElementType = $this$mapBuiltInType.getPrimitiveArrayType(constructor2);
        if (arrayElementType != null) {
            return typeFactory.createFromString('[' + JvmPrimitiveType.get(arrayElementType).getDesc());
        }
        if ($this$mapBuiltInType.isUnderKotlinPackage(constructor2)) {
            ClassId classId;
            ClassId classId2;
            FqNameUnsafe fqNameUnsafe = $this$mapBuiltInType.getClassFqNameUnsafe(constructor2);
            if (fqNameUnsafe != null) {
                FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
                JavaToKotlinClassMap javaToKotlinClassMap = JavaToKotlinClassMap.INSTANCE;
                FqNameUnsafe p0 = fqNameUnsafe2;
                boolean bl = false;
                classId2 = javaToKotlinClassMap.mapKotlinToJava(p0);
            } else {
                classId2 = classId = null;
            }
            if (classId != null) {
                if (!mode.getKotlinCollectionsToJavaCollections()) {
                    boolean bl;
                    block12: {
                        Iterable $this$any$iv = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                JavaToKotlinClassMap.PlatformMutabilityMapping it = (JavaToKotlinClassMap.PlatformMutabilityMapping)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual(it.getJavaClass(), classId)) continue;
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return null;
                    }
                }
                String string2 = JvmClassName.byClassId(classId).getInternalName();
                Intrinsics.checkNotNullExpressionValue(string2, "byClassId(classId).internalName");
                return typeFactory.createObjectType(string2);
            }
        }
        return null;
    }
}

