/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jreleaser.sdk.github.api.GhAsset;
import org.jreleaser.sdk.github.api.GhBranch;
import org.jreleaser.sdk.github.api.GhDiscussion;
import org.jreleaser.sdk.github.api.GhIssue;
import org.jreleaser.sdk.github.api.GhLabel;
import org.jreleaser.sdk.github.api.GhMilestone;
import org.jreleaser.sdk.github.api.GhOrganization;
import org.jreleaser.sdk.github.api.GhPackageVersion;
import org.jreleaser.sdk.github.api.GhRelease;
import org.jreleaser.sdk.github.api.GhReleaseNotes;
import org.jreleaser.sdk.github.api.GhReleaseNotesParams;
import org.jreleaser.sdk.github.api.GhRepository;
import org.jreleaser.sdk.github.api.GhSearchUser;
import org.jreleaser.sdk.github.api.GhTag;
import org.jreleaser.sdk.github.api.GhUser;
import org.jreleaser.sdk.github.internal.Page;

public interface GithubAPI {
    @RequestLine(value="GET /repos/{owner}/{repo}")
    public GhRepository getRepository(@Param(value="owner") String var1, @Param(value="repo") String var2);

    @RequestLine(value="GET /orgs/{org}")
    public GhOrganization getOrganization(@Param(value="org") String var1);

    @RequestLine(value="POST /orgs/{org}/repos")
    @Headers(value={"Content-Type: application/json"})
    public GhRepository createRepository(Map<String, Object> var1, @Param(value="org") String var2);

    @RequestLine(value="POST /user/repos")
    @Headers(value={"Content-Type: application/json"})
    public GhRepository createRepository(Map<String, Object> var1);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases/tags/{tag}")
    public GhRelease getReleaseByTagName(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="tag") String var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases/{id}")
    public GhRelease getRelease(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="id") Long var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/{id}")
    public void deleteRelease(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="id") Long var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/git/refs/tags/{tag}")
    public void deleteTag(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="tag") String var3);

    @RequestLine(value="POST /repos/{owner}/{repo}/releases")
    @Headers(value={"Content-Type: application/json"})
    public GhRelease createRelease(GhRelease var1, @Param(value="owner") String var2, @Param(value="repo") String var3);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/releases/{id}")
    @Headers(value={"Content-Type: application/json"})
    public void updateRelease(GhRelease var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="id") Long var4);

    @RequestLine(value="GET /repos/{owner}/{repo}/milestones")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhMilestone>> listMilestones(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/milestones/{number}")
    @Headers(value={"Content-Type: application/json"})
    public void updateMilestone(Map<String, Object> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="number") Integer var4);

    @RequestLine(value="GET /search/users")
    @Headers(value={"Content-Type: application/json"})
    public GhSearchUser searchUser(@QueryMap Map<String, String> var1);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhRelease>> listReleases(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/branches")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhBranch>> listBranches(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/releases/{releaseId}/assets")
    @Headers(value={"Content-Type: application/json"})
    public List<GhAsset> listAssets(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="releaseId") Long var3);

    @RequestLine(value="DELETE /repos/{owner}/{repo}/releases/assets/{assetId}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteAsset(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="assetId") Long var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/labels")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhLabel>> listLabels(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="POST /repos/{owner}/{repo}/labels")
    @Headers(value={"Content-Type: application/json"})
    public GhLabel createLabel(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="name") String var3, @Param(value="color") String var4, @Param(value="description") String var5);

    @RequestLine(value="GET /repos/{owner}/{repo}/issues/{issueNumber}")
    @Headers(value={"Content-Type: application/json"})
    public GhIssue findIssue(@Param(value="owner") String var1, @Param(value="repo") String var2, @Param(value="issueNumber") int var3);

    @RequestLine(value="POST /repos/{owner}/{repo}/issues/{issueNumber}/labels")
    @Headers(value={"Content-Type: application/json"})
    public void labelIssue(Map<String, List<String>> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="issueNumber") Long var4);

    @RequestLine(value="POST /repos/{owner}/{repo}/issues/{issueNumber}/comments")
    @Headers(value={"Content-Type: application/json"})
    public void commentIssue(Map<String, String> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="issueNumber") Long var4);

    @RequestLine(value="PATCH /repos/{owner}/{repo}/issues/{issueNumber}")
    @Headers(value={"Content-Type: application/json"})
    public void updateIssue(Map<String, Object> var1, @Param(value="owner") String var2, @Param(value="repo") String var3, @Param(value="issueNumber") Long var4);

    @RequestLine(value="GET /orgs/{org}/teams/{team}/discussions")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhDiscussion>> listDiscussions(@Param(value="org") String var1, @Param(value="team") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="POST /orgs/{org}/teams/{team}/discussions")
    @Headers(value={"Content-Type: application/json"})
    public void createDiscussion(GhDiscussion var1, @Param(value="org") String var2, @Param(value="team") String var3);

    @RequestLine(value="GET /repos/{owner}/{repo}/tags")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhTag>> listTags(@Param(value="owner") String var1, @Param(value="repo") String var2, @QueryMap Map<String, Object> var3);

    @RequestLine(value="GET /users/{username}")
    @Headers(value={"Content-Type: application/json"})
    public GhUser getUser(@Param(value="username") String var1);

    @RequestLine(value="POST /repos/{owner}/{repo}/releases/generate-notes")
    @Headers(value={"Content-Type: application/json"})
    public GhReleaseNotes generateReleaseNotes(GhReleaseNotesParams var1, @Param(value="owner") String var2, @Param(value="repo") String var3);

    @RequestLine(value="DELETE /user/packages/{packageType}/{packageName}/versions/{versionId}")
    @Headers(value={"Content-Type: application/json"})
    public void deletePackageVersion(@Param(value="packageType") String var1, @Param(value="packageName") String var2, @Param(value="versionId") String var3);

    @RequestLine(value="DELETE /user/packages/{packageType}/{packageName}")
    @Headers(value={"Content-Type: application/json"})
    public void deletePackage(@Param(value="packageType") String var1, @Param(value="packageName") String var2);

    @RequestLine(value="GET /user/packages/{packageType}/{packageName}/versions")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhPackageVersion>> listPackageVersions0(@Param(value="packageType") String var1, @Param(value="packageName") String var2);

    @RequestLine(value="GET")
    @Headers(value={"Content-Type: application/json"})
    public Page<List<GhPackageVersion>> listPackageVersions1(URI var1);
}

