/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.HttpDownloader;
import org.jreleaser.model.internal.validation.common.HttpValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class HttpDownloaderValidator {
    private HttpDownloaderValidator() {
    }

    public static void validateHttpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, HttpDownloader> http = context.getModel().getDownload().getHttp();
        if (!http.isEmpty()) {
            context.getLogger().debug("download.http");
        }
        for (Map.Entry<String, HttpDownloader> e : http.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateDownload()) continue;
            HttpDownloaderValidator.validateHttp(context, e.getValue(), errors);
        }
    }

    private static void validateHttp(JReleaserContext context, HttpDownloader downloader, Errors errors) {
        context.getLogger().debug("download.http.{}", new Object[]{downloader.getName()});
        Validator.resolveActivatable(context, (Activatable)downloader, CollectionUtils.listOf((Object[])new String[]{"download.http." + downloader.getName(), "download.http"}), "ALWAYS");
        if (!downloader.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        HttpValidator.validateHttp(context, downloader, "download", downloader.getName(), errors);
        Validator.validateTimeout(downloader);
        if (downloader.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"download.http." + downloader.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : downloader.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"download.http." + downloader.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

