/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractArtifact;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class Glob
extends AbstractArtifact<Glob>
implements Domain,
ExtraProperties {
    private static final long serialVersionUID = -7355184705247562138L;
    private String pattern;
    @JsonIgnore
    private Set<Artifact> artifacts;
    private String directory;
    @JsonIgnore
    private final org.jreleaser.model.api.common.Glob immutable = new org.jreleaser.model.api.common.Glob(){
        private static final long serialVersionUID = 7275219810370004662L;

        public Active getActive() {
            return Glob.this.getActive();
        }

        public boolean isEnabled() {
            return Glob.this.isEnabled();
        }

        public boolean isSelected() {
            return Glob.this.isSelected();
        }

        public String getPattern() {
            return Glob.this.pattern;
        }

        public String getPlatform() {
            return Glob.this.getPlatform();
        }

        public String getDirectory() {
            return Glob.this.directory;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Glob.this.asMap(full));
        }

        public String getPrefix() {
            return Glob.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Glob.this.getExtraProperties());
        }
    };

    public org.jreleaser.model.api.common.Glob asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Glob source) {
        super.merge(source);
        this.pattern = this.merge(this.pattern, source.pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return;
        }
        this.pattern = pattern.trim();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("pattern", this.pattern);
        props.put("platform", this.getPlatform());
        props.put("directory", this.directory);
        props.put("extraProperties", this.getExtraProperties());
        return props;
    }

    public Set<Artifact> getResolvedArtifacts(JReleaserContext context) {
        return this.getResolvedArtifactsPattern(context);
    }

    public Set<Artifact> getResolvedArtifactsPattern(JReleaserContext context) {
        if (!this.isActiveAndSelected()) {
            return Collections.emptySet();
        }
        if (null == this.artifacts) {
            this.setPattern(Artifacts.resolveForGlob(this.getPattern(), context, this));
            this.normalizePattern();
            this.artifacts = Artifacts.resolveFiles(context, this.resolveDirectory(context), Collections.singletonList(this.pattern));
            this.artifacts.forEach(artifact -> {
                artifact.setPlatform(this.getPlatform());
                artifact.setActive(this.getActive());
                if (this.isSelected()) {
                    artifact.select();
                }
                artifact.setExtraProperties(this.getExtraProperties());
            });
        }
        return this.artifacts;
    }

    private Path resolveDirectory(JReleaserContext context) {
        Path path = context.getBasedir();
        if (StringUtils.isNotBlank((String)this.directory)) {
            this.directory = this.normalizeForWindows(Artifacts.resolveForGlob(this.directory, context, this));
            path = context.getBasedir().resolve(Paths.get(this.directory, new String[0])).normalize();
            if (context.getMode().validatePaths() && !Files.exists(path, new LinkOption[0])) {
                throw new JReleaserException(RB.$((String)"ERROR_path_does_not_exist", (Object[])new Object[]{context.relativizeToBasedir(path)}));
            }
        }
        return path;
    }

    private void normalizePattern() {
        String path;
        if (!this.pattern.startsWith("glob:") && !this.pattern.startsWith("regex:")) {
            this.pattern = "glob:" + this.pattern;
        }
        String prefix = this.pattern.startsWith("glob:") ? "glob:" : "regex:";
        String root = this.pattern.startsWith("glob:") ? "**" : ".*";
        String test = path = this.pattern.substring(prefix.length());
        if (PlatformUtils.isWindows()) {
            test = test.replace("*", "x");
        }
        this.pattern = !Paths.get(test, new String[0]).isAbsolute() ? (path.startsWith(root) ? prefix + path : prefix + root + File.separator + path) : prefix + path;
        this.pattern = this.normalizeForWindows(this.pattern);
    }

    private String normalizeForWindows(String str) {
        if (!PlatformUtils.isWindows()) {
            return str;
        }
        return str.replace("/", "\\").replace("\\\\", "\\").replace("\\", "\\\\");
    }
}

