/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Twitter;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class TwitterValidator
extends Validator {
    public static void validateTwitter(JReleaserContext context, Twitter twitter, Errors errors) {
        context.getLogger().debug("announce.twitter");
        if (!twitter.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        twitter.setConsumerKey(TwitterValidator.checkProperty(context, "TWITTER_CONSUMER_KEY", "twitter.consumerKey", twitter.getConsumerKey(), errors, context.isDryrun()));
        twitter.setConsumerSecret(TwitterValidator.checkProperty(context, "TWITTER_CONSUMER_SECRET", "twitter.consumerSecret", twitter.getConsumerSecret(), errors, context.isDryrun()));
        twitter.setAccessToken(TwitterValidator.checkProperty(context, "TWITTER_ACCESS_TOKEN", "twitter.accessToken", twitter.getAccessToken(), errors, context.isDryrun()));
        twitter.setAccessTokenSecret(TwitterValidator.checkProperty(context, "TWITTER_ACCESS_TOKEN_SECRET", "twitter.accessTokenSecret", twitter.getAccessTokenSecret(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)twitter.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(twitter.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"twitter.statusTemplate", twitter.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)twitter.getStatus()) && StringUtils.isBlank((String)twitter.getStatusTemplate()) && twitter.getStatuses().isEmpty()) {
            twitter.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        TwitterValidator.validateTimeout(twitter);
    }
}

