/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.reporting;

import org.kordamp.jarviz.reporting.Formatter;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.reporting.Report;
import org.kordamp.jarviz.util.StringUtils;

public class XmlFormatter
extends Formatter {
    public static final XmlFormatter INSTANCE = new XmlFormatter();
    private static final String OPEN = "<";
    private static final String OPEN_SLASH = "</";
    private static final String CLOSE = ">";
    private static final String CDATA_OPEN = "<![CDATA[";
    private static final String CDATA_CLOSE = "]]>";

    private XmlFormatter() {
    }

    @Override
    protected void append(Report report, Node node) {
        if (StringUtils.isBlank(node.getValue()) && node.getChildren().isEmpty()) {
            return;
        }
        report.indent(this.indentationFor(node)).append(this.openXmlElement(node.getName()));
        if (StringUtils.isNotBlank(node.getValue())) {
            report.append(this.formatValue(node));
        } else {
            report.newLine();
            for (Node child : node.getChildren()) {
                this.append(report, child);
            }
            report.indent(this.indentationFor(node));
        }
        report.append(this.closeXmlElement(node.getName())).newLine();
    }

    @Override
    protected String formatValue(Node node) {
        String value = node.getValue();
        if (!value.contains(System.lineSeparator())) {
            return this.formatValue(value);
        }
        String indentation = "  ".repeat(this.indentationFor(node, 1));
        StringBuilder b = new StringBuilder(System.lineSeparator());
        for (String line : value.split(System.lineSeparator())) {
            b.append(indentation).append(line).append(System.lineSeparator());
        }
        return this.formatValue(b.toString());
    }

    private String openXmlElement(String str) {
        return OPEN + str + CLOSE;
    }

    private String closeXmlElement(String str) {
        return OPEN_SLASH + str + CLOSE;
    }

    @Override
    protected String formatValue(String value) {
        return value.contains(OPEN) || value.contains(CLOSE) ? this.cdata(value) : value.trim();
    }

    private String cdata(String value) {
        return CDATA_OPEN + value + CDATA_CLOSE;
    }
}

