/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.util.Set;
import java.util.stream.Collectors;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.processors.PackageValidateJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;

public class PackagesValidateCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        PackageValidateJarProcessor processor = new PackageValidateJarProcessor(jarFileResolver);
        Set<JarProcessor.JarFileResult<Set<String>>> results = processor.getResult();
        this.output(configuration, results);
        this.report(configuration, results);
        Set errors = results.stream().map(r -> r.getJarFileName() + " has invalid package names: " + r.getResult()).collect(Collectors.toSet());
        if (configuration.isFailOnError()) {
            throw new JarvizException(String.join((CharSequence)System.lineSeparator(), errors));
        }
        configuration.getErr().println(String.join((CharSequence)System.lineSeparator(), errors));
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<Set<String>>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<Set<String>> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(outputFormat, root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<Set<String>> result) {
        configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
        configuration.getOut().println(this.$$("output.total", result.getResult().size()));
        result.getResult().forEach(configuration.getOut()::println);
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<Set<String>>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<Set<String>> result : results) {
                this.buildReport(format, root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Format format, Node root, JarProcessor.JarFileResult<Set<String>> result) {
        this.appendSubject(root, result.getJarPath(), "packages validate", resultNode -> {
            resultNode.node(RB.$("report.key.total", new Object[0])).value(((Set)result.getResult()).size()).end();
            Node packages = resultNode.array(RB.$("report.key.packages", new Object[0]));
            for (String thePackage : (Set)result.getResult()) {
                if (format == Format.TXT) {
                    packages.node(thePackage);
                    continue;
                }
                packages.collapsable(RB.$("report.key.package", new Object[0])).value(thePackage).end();
            }
        });
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
    }
}

