/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.ConstructorInvocationContext;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.InterceptorRegistry;
import io.micronaut.aop.chain.AbstractInterceptorChain;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Internal
public final class ConstructorInterceptorChain<T>
extends AbstractInterceptorChain<T, T>
implements ConstructorInvocationContext<T> {
    private final BeanConstructor<T> beanConstructor;
    private Object[] internalParameters = ArrayUtils.EMPTY_OBJECT_ARRAY;

    public ConstructorInterceptorChain(@NonNull BeanConstructor<T> beanConstructor, @NonNull Interceptor<T, T>[] interceptors, Object ... originalParameters) {
        super(interceptors, originalParameters);
        this.beanConstructor = Objects.requireNonNull(beanConstructor, "Bean constructor cannot be null");
    }

    public ConstructorInterceptorChain(@NonNull BeanDefinition<T> beanDefinition, @NonNull BeanConstructor<T> beanConstructor, @NonNull Interceptor<T, T>[] interceptors, Object ... originalParameters) {
        this(beanConstructor, interceptors, ConstructorInterceptorChain.resolveConcreteSubset(beanDefinition, originalParameters));
        this.internalParameters = ConstructorInterceptorChain.resolveInterceptorArguments(beanDefinition, originalParameters);
    }

    @Override
    @NonNull
    public InterceptorKind getKind() {
        return InterceptorKind.AROUND_CONSTRUCT;
    }

    @Override
    public T getTarget() {
        throw new UnsupportedOperationException("The target cannot be retrieved for Constructor interception");
    }

    @Override
    public T proceed() throws RuntimeException {
        if (this.interceptorCount == 0 || this.index == this.interceptorCount) {
            Object[] finalParameters = ArrayUtils.isNotEmpty((Object[])this.internalParameters) ? ArrayUtils.concat((Object[])this.getParameterValues(), (Object[])this.internalParameters) : this.getParameterValues();
            return (T)this.beanConstructor.instantiate(finalParameters);
        }
        Interceptor interceptor = this.interceptors[this.index++];
        if (LOG.isTraceEnabled()) {
            LOG.trace("Proceeded to next interceptor [{}] in chain for constructor invocation: {}", (Object)interceptor, this.beanConstructor);
        }
        return (T)interceptor.intercept(this);
    }

    @NonNull
    public Argument<?>[] getArguments() {
        return this.beanConstructor.getArguments();
    }

    public T invoke(T instance, Object ... arguments) {
        throw new UnsupportedOperationException("Existing instances cannot be invoked with Constructor injection");
    }

    @Override
    @NonNull
    public BeanConstructor<T> getConstructor() {
        return this.beanConstructor;
    }

    @Internal
    @NonNull
    public static <T1> T1 instantiate(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanContext beanContext, @Nullable List<BeanRegistration<Interceptor<T1, T1>>> interceptors, @NonNull BeanDefinition<T1> definition, @NonNull BeanConstructor<T1> constructor, Object ... parameters) {
        if (interceptors == null) {
            AnnotationMetadataHierarchy hierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{definition.getAnnotationMetadata(), constructor.getAnnotationMetadata()});
            List annotationNames = InterceptorBindingQualifier.resolveInterceptorValues((AnnotationMetadata)hierarchy);
            Collection resolved = ((DefaultBeanContext)beanContext).getBeanRegistrations(resolutionContext, Interceptor.ARGUMENT, Qualifiers.byInterceptorBinding((Collection)annotationNames));
            interceptors = new ArrayList(resolved);
        }
        InterceptorRegistry interceptorRegistry = (InterceptorRegistry)beanContext.getBean(InterceptorRegistry.ARGUMENT);
        Interceptor<T1, T1>[] resolvedInterceptors = interceptorRegistry.resolveConstructorInterceptors(constructor, interceptors);
        return Objects.requireNonNull(new ConstructorInterceptorChain<T1>(definition, constructor, resolvedInterceptors, parameters).proceed(), "Constructor interceptor chain illegally returned null for constructor: " + constructor.getDescription());
    }

    private static Object[] resolveConcreteSubset(BeanDefinition<?> beanDefinition, Object[] originalParameters) {
        if (beanDefinition instanceof AdvisedBeanType) {
            if (originalParameters.length < 3) {
                throw new IllegalStateException("Invalid intercepted bean constructor. This should never happen. Report an issue to the project maintainers.");
            }
            return Arrays.copyOfRange(originalParameters, 0, originalParameters.length - 3);
        }
        return originalParameters;
    }

    private static Object[] resolveInterceptorArguments(BeanDefinition<?> beanDefinition, Object[] originalParameters) {
        if (beanDefinition instanceof AdvisedBeanType) {
            if (originalParameters.length < 3) {
                throw new IllegalStateException("Invalid intercepted bean constructor. This should never happen. Report an issue to the project maintainers.");
            }
            return Arrays.copyOfRange(originalParameters, originalParameters.length - 3, originalParameters.length);
        }
        return originalParameters;
    }
}

