/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.aop;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.spring.context.factory.MicronautBeanFactory;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanCreationException;

@Singleton
@Internal
public class SpringConfigurationInterceptor
implements MethodInterceptor<Object, Object> {
    private final Map<ExecutableMethod, Object> computedSingletons = new ConcurrentHashMap<ExecutableMethod, Object>(30);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        boolean isSingleton = MicronautBeanFactory.isSingleton((AnnotationMetadata)annotationMetadata);
        if (isSingleton) {
            ExecutableMethod method = context.getExecutableMethod();
            Map<ExecutableMethod, Object> map = this.computedSingletons;
            synchronized (map) {
                Object o = this.computedSingletons.get(method);
                if (o == null) {
                    o = context.proceed();
                    if (o == null) {
                        throw new BeanCreationException("Bean factor method [" + method + "] returned null");
                    }
                    this.computedSingletons.put(method, o);
                }
                return o;
            }
        }
        return context.proceed();
    }
}

