/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryDisabler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.artifacts.repositories.transport.NetworkingIssueVerifier;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.resolve.ArtifactNotFoundException;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactFileResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.ErroringResolveResult;

public class ErrorHandlingModuleComponentRepository
implements ModuleComponentRepository<ModuleComponentGraphResolveState> {
    private final ModuleComponentRepository<ModuleComponentGraphResolveState> delegate;
    private final ErrorHandlingModuleComponentRepositoryAccess local;
    private final ErrorHandlingModuleComponentRepositoryAccess remote;

    public ErrorHandlingModuleComponentRepository(ModuleComponentRepository<ModuleComponentGraphResolveState> delegate, RepositoryDisabler remoteRepositoryDisabler) {
        this.delegate = delegate;
        this.local = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getLocalAccess(), this.getId(), RepositoryDisabler.NoOpDisabler.INSTANCE, this.getName());
        this.remote = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getRemoteAccess(), this.getId(), remoteRepositoryDisabler, this.getName());
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> getLocalAccess() {
        return this.local;
    }

    @Override
    public ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> getRemoteAccess() {
        return this.remote;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        return this.delegate.getArtifactCache();
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.delegate.getComponentMetadataSupplier();
    }

    private static final class ErrorHandlingModuleComponentRepositoryAccess
    implements ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> {
        private static final Logger LOGGER = Logging.getLogger(ErrorHandlingModuleComponentRepositoryAccess.class);
        private static final String MAX_TENTATIVES_BEFORE_DISABLING = "org.gradle.internal.repository.max.tentatives";
        private static final String INITIAL_BACKOFF_MS = "org.gradle.internal.repository.initial.backoff";
        private final ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> delegate;
        private final String repositoryId;
        private final RepositoryDisabler repositoryDisabler;
        private final int maxTentativesCount;
        private final int initialBackOff;
        private final String repositoryName;

        private ErrorHandlingModuleComponentRepositoryAccess(ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> delegate, String repositoryId, RepositoryDisabler repositoryDisabler, String repositoryName) {
            this(delegate, repositoryId, repositoryDisabler, Integer.getInteger(MAX_TENTATIVES_BEFORE_DISABLING, 3), Integer.getInteger(INITIAL_BACKOFF_MS, 1000), repositoryName);
        }

        private ErrorHandlingModuleComponentRepositoryAccess(ModuleComponentRepositoryAccess<ModuleComponentGraphResolveState> delegate, String repositoryId, RepositoryDisabler repositoryDisabler, int maxTentativesCount, int initialBackoff, String repositoryName) {
            this.repositoryName = repositoryName;
            assert (maxTentativesCount > 0) : "Max tentatives must be > 0";
            assert (initialBackoff >= 0) : "Initial backoff must be >= 0";
            this.delegate = delegate;
            this.repositoryId = repositoryId;
            this.repositoryDisabler = repositoryDisabler;
            this.maxTentativesCount = maxTentativesCount;
            this.initialBackOff = initialBackoff;
        }

        public String toString() {
            return "error handling > " + this.delegate.toString();
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            this.performOperationWithRetries(result, () -> this.delegate.listModuleVersions(dependency, result), cause -> new ModuleVersionResolveException((ComponentSelector)dependency.getSelector(), (Factory<String>)((Factory)() -> ErrorHandlingModuleComponentRepositoryAccess.buildDisabledRepositoryErrorMessage(this.repositoryName))), cause -> {
                ModuleComponentSelector selector = dependency.getSelector();
                return new ModuleVersionResolveException((ComponentSelector)selector, (Factory<String>)((Factory)() -> "Failed to list versions for " + selector.getGroup() + ":" + selector.getModule() + "."), (Throwable)cause);
            });
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentGraphResolveState> result) {
            this.performOperationWithRetries(result, () -> this.delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result), cause -> new ModuleVersionResolveException(moduleComponentIdentifier, (Factory<String>)((Factory)() -> ErrorHandlingModuleComponentRepositoryAccess.buildDisabledRepositoryErrorMessage(this.repositoryName)), (Throwable)cause), cause -> new ModuleVersionResolveException(moduleComponentIdentifier, (Throwable)cause));
        }

        @Override
        public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            this.performOperationWithRetries(result, () -> this.delegate.resolveArtifactsWithType(component, artifactType, result), cause -> new ArtifactResolveException(component.getId(), ErrorHandlingModuleComponentRepositoryAccess.buildDisabledRepositoryErrorMessage(this.repositoryName), (Throwable)cause), cause -> new ArtifactResolveException(component.getId(), (Throwable)cause));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result) {
            this.performOperationWithRetries(result, () -> {
                ArtifactResolveException failure;
                this.delegate.resolveArtifact(artifact, moduleSources, result);
                if (result.hasResult() && !((failure = result.getFailure()) instanceof ArtifactNotFoundException)) {
                    return failure;
                }
                return null;
            }, cause -> new ArtifactResolveException(artifact.getId(), ErrorHandlingModuleComponentRepositoryAccess.buildDisabledRepositoryErrorMessage(this.repositoryName), (Throwable)cause), cause -> new ArtifactResolveException(artifact.getId(), (Throwable)cause));
        }

        private static String buildDisabledRepositoryErrorMessage(String repositoryName) {
            return String.format("Repository %s is disabled due to earlier error below:", repositoryName);
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void performOperationWithRetries(R result, Callable<E> operation, Transformer<E, Throwable> onDisabled, Transformer<E, Throwable> onError) {
            if (this.checkToHandleDisabledRepository(result, onDisabled)) {
                return;
            }
            this.tryResolveAndMaybeDisable(result, operation, onError);
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void performOperationWithRetries(R result, Runnable operation, Transformer<E, Throwable> onDisabled, Transformer<E, Throwable> onError) {
            if (this.checkToHandleDisabledRepository(result, onDisabled)) {
                return;
            }
            this.tryResolveAndMaybeDisable(result, operation, onError);
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> boolean checkToHandleDisabledRepository(R result, Transformer<E, Throwable> onDisabled) {
            if (this.repositoryDisabler.isDisabled(this.repositoryId)) {
                Throwable reason = this.repositoryDisabler.getDisabledReason(this.repositoryId).get();
                Throwable failure = (Throwable)onDisabled.transform((Object)reason);
                result.failed((Throwable)failure);
                return true;
            }
            return false;
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void tryResolveAndMaybeDisable(R result, Runnable operation, Transformer<E, Throwable> onError) {
            this.tryResolveAndMaybeDisable(result, () -> {
                operation.run();
                return null;
            }, onError);
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void tryResolveAndMaybeDisable(R result, Callable<E> operation, Transformer<E, Throwable> onError) {
            int retries = 0;
            int backoff = this.initialBackOff;
            while (retries < this.maxTentativesCount) {
                boolean doNotRetry;
                Throwable failure;
                ++retries;
                Exception unexpectedFailure = null;
                try {
                    failure = (Throwable)operation.call();
                    if (failure == null) {
                        if (retries > 1) {
                            LOGGER.debug("Successfully fetched external resource after {} retries", (Object)(retries - 1));
                        }
                        return;
                    }
                }
                catch (Exception throwable) {
                    unexpectedFailure = throwable;
                    failure = (Throwable)onError.transform((Object)throwable);
                }
                boolean bl = doNotRetry = NetworkingIssueVerifier.isLikelyPermanentNetworkIssue(failure) || !NetworkingIssueVerifier.isLikelyTransientNetworkingIssue(failure);
                if (doNotRetry || retries == this.maxTentativesCount) {
                    if (unexpectedFailure != null) {
                        this.repositoryDisabler.tryDisableRepository(this.repositoryId, failure);
                    }
                    result.failed((Throwable)failure);
                    break;
                }
                LOGGER.debug("Error while accessing remote repository {}. Waiting {}ms before next retry. {} retries left", new Object[]{this.repositoryName, backoff, this.maxTentativesCount - retries, failure});
                try {
                    Thread.sleep(backoff);
                    backoff *= 2;
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return this.delegate.estimateMetadataFetchingCost(moduleComponentIdentifier);
        }
    }
}

