/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.CheckersComponentKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.LocalPropertyCollector;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfoCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.cfa.FirControlFlowChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J*\u0010\u0014\u001a\u00020\u000b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J&\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J&\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirControlFlowAnalyzer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cfaCheckers", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/cfa/FirControlFlowChecker;", "variableAssignmentCheckers", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "analyzeClassInitializer", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "analyzeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "analyzePropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "analyzePropertyInitializer", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "runAssignmentCfaCheckers", "checkers"})
public final class FirControlFlowAnalyzer {
    @NotNull
    private final Set<FirControlFlowChecker> cfaCheckers;
    @NotNull
    private final Set<AbstractFirPropertyInitializationChecker> variableAssignmentCheckers;

    public FirControlFlowAnalyzer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.cfaCheckers = CheckersComponentKt.getCheckersComponent(session2).getDeclarationCheckers().getControlFlowAnalyserCheckers();
        this.variableAssignmentCheckers = CheckersComponentKt.getCheckersComponent(session2).getDeclarationCheckers().getVariableAssignmentCfaBasedCheckers();
    }

    public final void analyzeClassInitializer(@NotNull FirClass<?> klass, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (graph2.getOwner() != null) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, context2);
        }
    }

    public final void analyzeFunction(@NotNull FirFunction<?> function2, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        block6: {
            Object it;
            Intrinsics.checkNotNullParameter(function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (graph2.getOwner() != null) {
                return;
            }
            Iterable $this$forEach$iv = this.cfaCheckers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirControlFlowChecker)element$iv;
                boolean bl2 = false;
                ((FirControlFlowChecker)it).analyze(graph2, reporter, context2);
            }
            Iterable $this$any$iv = context2.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (FirDeclaration)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof FirProperty || it instanceof FirFunction)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.runAssignmentCfaCheckers(graph2, reporter);
    }

    public final void analyzePropertyInitializer(@NotNull FirProperty property2, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (graph2.getOwner() != null) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, context2);
        }
        this.runAssignmentCfaCheckers(graph2, reporter);
    }

    public final void analyzePropertyAccessor(@NotNull FirPropertyAccessor accessor, @NotNull ControlFlowGraph graph2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (graph2.getOwner() != null) {
            return;
        }
        Iterable $this$forEach$iv = this.cfaCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirControlFlowChecker it = (FirControlFlowChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, context2);
        }
        this.runAssignmentCfaCheckers(graph2, reporter);
    }

    private final void runAssignmentCfaCheckers(ControlFlowGraph graph2, DiagnosticReporter reporter) {
        Set<FirPropertySymbol> properties2 = LocalPropertyCollector.Companion.collect(graph2);
        if (properties2.isEmpty()) {
            return;
        }
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data = new PropertyInitializationInfoCollector(properties2).getData(graph2);
        Iterable $this$forEach$iv = this.variableAssignmentCheckers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractFirPropertyInitializationChecker it = (AbstractFirPropertyInitializationChecker)element$iv;
            boolean bl = false;
            it.analyze(graph2, reporter, data, properties2);
        }
    }
}

