/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ModuleComponentSelectorSerializer
implements Serializer<ModuleComponentSelector> {
    private final AttributeContainerSerializer attributeContainerSerializer;

    public ModuleComponentSelectorSerializer(AttributeContainerSerializer attributeContainerSerializer) {
        this.attributeContainerSerializer = attributeContainerSerializer;
    }

    public ModuleComponentSelector read(Decoder decoder) throws IOException {
        String group = decoder.readString();
        String name = decoder.readString();
        VersionConstraint versionConstraint = this.readVersionConstraint(decoder);
        ImmutableAttributes attributes = this.readAttributes(decoder);
        List<Capability> capabilities = this.readCapabilities(decoder);
        return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(group, name), versionConstraint, (AttributeContainer)attributes, capabilities);
    }

    public VersionConstraint readVersionConstraint(Decoder decoder) throws IOException {
        String required = decoder.readString();
        String preferred = decoder.readString();
        String strictly = decoder.readString();
        int cpt = decoder.readSmallInt();
        ArrayList rejects = Lists.newArrayListWithCapacity((int)cpt);
        for (int i = 0; i < cpt; ++i) {
            rejects.add(decoder.readString());
        }
        return new DefaultImmutableVersionConstraint(preferred, required, strictly, rejects);
    }

    public void write(Encoder encoder, ModuleComponentSelector value) throws IOException {
        encoder.writeString((CharSequence)value.getGroup());
        encoder.writeString((CharSequence)value.getModule());
        this.writeVersionConstraint(encoder, value.getVersionConstraint());
        this.writeAttributes(encoder, ((AttributeContainerInternal)value.getAttributes()).asImmutable());
        this.writeCapabilities(encoder, value.getRequestedCapabilities());
    }

    public void write(Encoder encoder, String group, String module, VersionConstraint version, ImmutableAttributes attributes, Collection<Capability> capabilities) throws IOException {
        encoder.writeString((CharSequence)group);
        encoder.writeString((CharSequence)module);
        this.writeVersionConstraint(encoder, version);
        this.writeAttributes(encoder, attributes);
        this.writeCapabilities(encoder, capabilities);
    }

    public void writeVersionConstraint(Encoder encoder, VersionConstraint cst) throws IOException {
        encoder.writeString((CharSequence)cst.getRequiredVersion());
        encoder.writeString((CharSequence)cst.getPreferredVersion());
        encoder.writeString((CharSequence)cst.getStrictVersion());
        List rejectedVersions = cst.getRejectedVersions();
        encoder.writeSmallInt(rejectedVersions.size());
        for (String rejectedVersion : rejectedVersions) {
            encoder.writeString((CharSequence)rejectedVersion);
        }
    }

    private ImmutableAttributes readAttributes(Decoder decoder) throws IOException {
        return this.attributeContainerSerializer.read(decoder);
    }

    private void writeAttributes(Encoder encoder, ImmutableAttributes attributes) throws IOException {
        this.attributeContainerSerializer.write(encoder, (AttributeContainer)attributes);
    }

    private List<Capability> readCapabilities(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)new ImmutableCapability(decoder.readString(), decoder.readString(), decoder.readNullableString()));
        }
        return builder.build();
    }

    private void writeCapabilities(Encoder encoder, Collection<Capability> capabilities) throws IOException {
        encoder.writeSmallInt(capabilities.size());
        for (Capability capability : capabilities) {
            encoder.writeString((CharSequence)capability.getGroup());
            encoder.writeString((CharSequence)capability.getName());
            encoder.writeNullableString((CharSequence)capability.getVersion());
        }
    }
}

