/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import javax.annotation.Nullable;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.AbstractManagedValueSnapshot;
import org.gradle.internal.snapshot.impl.ManagedValueSnapshot;
import org.gradle.internal.state.Managed;

class IsolatedManagedValue
extends AbstractManagedValueSnapshot<Isolatable<?>>
implements Isolatable<Object> {
    private final Managed.Factory factory;
    private final Class<?> targetType;

    public IsolatedManagedValue(Class<?> targetType, Managed.Factory factory, Isolatable<?> state) {
        super(state);
        this.targetType = targetType;
        this.factory = factory;
    }

    @Override
    public ValueSnapshot asSnapshot() {
        return new ManagedValueSnapshot(this.targetType.getName(), ((Isolatable)this.state).asSnapshot());
    }

    @Override
    public Object isolate() {
        return this.factory.fromState(this.targetType, ((Isolatable)this.state).isolate());
    }

    @Override
    @Nullable
    public <S> S coerce(Class<S> type) {
        if (type.isAssignableFrom(this.targetType)) {
            return type.cast(this.isolate());
        }
        return type.cast(this.factory.fromState(type, ((Isolatable)this.state).isolate()));
    }
}

