/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.BuildableCompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CollectingMacroLookup;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.DefaultIncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncementalCompileSourceProcessor;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileState;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCompileFilesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalCompileFilesFactory.class);
    private static final String IGNORE_UNRESOLVED_HEADERS_IN_DEPENDENCIES_PROPERTY_NAME = "org.gradle.internal.native.headers.unresolved.dependencies.ignore";
    private final SourceIncludesParser sourceIncludesParser;
    private final SourceIncludesResolver sourceIncludesResolver;
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final boolean ignoreUnresolvedHeadersInDependencies;

    public IncrementalCompileFilesFactory(SourceIncludesParser sourceIncludesParser, SourceIncludesResolver sourceIncludesResolver, FileSystemSnapshotter fileSystemSnapshotter) {
        this.sourceIncludesParser = sourceIncludesParser;
        this.sourceIncludesResolver = sourceIncludesResolver;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.ignoreUnresolvedHeadersInDependencies = Boolean.getBoolean(IGNORE_UNRESOLVED_HEADERS_IN_DEPENDENCIES_PROPERTY_NAME);
    }

    public IncementalCompileSourceProcessor filesFor(CompilationState previousCompileState) {
        return new DefaultIncementalCompileSourceProcessor(previousCompileState);
    }

    private static class FileVisitResult
    implements CollectingMacroLookup.MacroSource {
        private final File file;
        private final IncludeFileResolutionResult result;
        private final IncludeFileState fileState;
        private final IncludeDirectives includeDirectives;
        private final List<FileVisitResult> included;
        private final CollectingMacroLookup includeFileDirectives;
        int traversalCount;

        FileVisitResult(File file, IncludeFileResolutionResult result, IncludeFileState fileState, IncludeDirectives includeDirectives, List<FileVisitResult> included, CollectingMacroLookup dependentIncludeDirectives) {
            this.file = file;
            this.result = result;
            this.fileState = fileState;
            this.includeDirectives = includeDirectives;
            this.included = included;
            this.includeFileDirectives = dependentIncludeDirectives;
        }

        FileVisitResult(File file) {
            this.file = file;
            this.result = IncludeFileResolutionResult.NoMacroIncludes;
            this.fileState = null;
            this.includeDirectives = null;
            this.included = Collections.emptyList();
            this.includeFileDirectives = null;
        }

        void collectDependencies(CollectingMacroLookup directives) {
            if (this.fileState != null) {
                directives.append(this);
            }
        }

        void collectFilesInto(int traversal, List<IncludeFileState> files) {
            if (this.traversalCount == traversal) {
                return;
            }
            this.traversalCount = traversal;
            if (this.fileState != null) {
                files.add(this.fileState);
                for (FileVisitResult include : this.included) {
                    include.collectFilesInto(traversal, files);
                }
            }
        }

        @Override
        public void collectInto(CollectingMacroLookup lookup) {
            if (this.fileState != null) {
                lookup.append(this.file, this.includeDirectives);
                this.includeFileDirectives.appendTo(lookup);
            }
        }
    }

    private static class FileDetails {
        final IncludeFileState state;
        final IncludeDirectives directives;
        @Nullable
        FileVisitResult results;

        FileDetails(IncludeFileState state, IncludeDirectives directives) {
            this.state = state;
            this.directives = directives;
        }
    }

    private static enum IncludeFileResolutionResult {
        NoMacroIncludes,
        HasMacroIncludes,
        UnresolvedMacroIncludes;

    }

    private class DefaultIncementalCompileSourceProcessor
    implements IncementalCompileSourceProcessor {
        private final CompilationState previous;
        private final BuildableCompilationState current = new BuildableCompilationState();
        private final List<File> toRecompile = new ArrayList<File>();
        private final Set<File> existingHeaders = Sets.newHashSet();
        private final Map<File, IncludeDirectives> includeDirectivesMap = new HashMap<File, IncludeDirectives>();
        private final Map<File, FileDetails> visitedFiles = new HashMap<File, FileDetails>();
        int traversalCount;
        private boolean hasUnresolvedHeaders;

        DefaultIncementalCompileSourceProcessor(CompilationState previousCompileState) {
            this.previous = previousCompileState == null ? new CompilationState() : previousCompileState;
        }

        @Override
        public IncrementalCompilation getResult() {
            return new DefaultIncrementalCompilation(this.current.snapshot(), this.toRecompile, this.getRemovedSources(), this.existingHeaders, this.hasUnresolvedHeaders, this.includeDirectivesMap);
        }

        @Override
        public void processSource(File sourceFile) {
            if (this.visitSourceFile(sourceFile)) {
                this.toRecompile.add(sourceFile);
            }
        }

        private boolean visitSourceFile(File sourceFile) {
            FileSnapshot fileSnapshot = IncrementalCompileFilesFactory.this.fileSystemSnapshotter.snapshotSelf(sourceFile);
            if (fileSnapshot.getType() != FileType.RegularFile) {
                return false;
            }
            SourceFileState previousState = this.previous.getState(sourceFile);
            CollectingMacroLookup visibleMacros = new CollectingMacroLookup();
            FileVisitResult result = this.visitFile(sourceFile, fileSnapshot, visibleMacros, new HashSet<HashCode>(), true);
            ArrayList<IncludeFileState> includedFiles = new ArrayList<IncludeFileState>();
            result.collectFilesInto(++this.traversalCount, includedFiles);
            SourceFileState newState = new SourceFileState(fileSnapshot.getContent().getContentMd5(), (ImmutableSet<IncludeFileState>)ImmutableSet.copyOf(includedFiles));
            this.current.setState(sourceFile, newState);
            this.includeDirectivesMap.put(sourceFile, result.includeDirectives);
            return previousState == null || result.result == IncludeFileResolutionResult.UnresolvedMacroIncludes || newState.hasChanged(previousState);
        }

        private FileVisitResult visitFile(File file, FileSnapshot fileSnapshot, CollectingMacroLookup visibleMacros, Set<HashCode> visited, boolean isSourceFile) {
            FileDetails fileDetails = this.visitedFiles.get(file);
            if (fileDetails != null && fileDetails.results != null) {
                visibleMacros.append(fileDetails.results);
                return fileDetails.results;
            }
            HashCode newHash = fileSnapshot.getContent().getContentMd5();
            if (!visited.add(newHash)) {
                return new FileVisitResult(file);
            }
            if (fileDetails == null) {
                IncludeDirectives includeDirectives = IncrementalCompileFilesFactory.this.sourceIncludesParser.parseIncludes(file);
                fileDetails = new FileDetails(new IncludeFileState(newHash, file), includeDirectives);
                this.visitedFiles.put(file, fileDetails);
            }
            CollectingMacroLookup includedFileDirectives = new CollectingMacroLookup();
            visibleMacros.append(file, fileDetails.directives);
            ArrayList<FileVisitResult> included = new ArrayList<FileVisitResult>(fileDetails.directives.getAll().size());
            IncludeFileResolutionResult result = IncludeFileResolutionResult.NoMacroIncludes;
            for (Include include : fileDetails.directives.getAll()) {
                SourceIncludesResolver.IncludeResolutionResult resolutionResult;
                if (include.getType() == IncludeType.MACRO && result == IncludeFileResolutionResult.NoMacroIncludes) {
                    result = IncludeFileResolutionResult.HasMacroIncludes;
                }
                if (!(resolutionResult = IncrementalCompileFilesFactory.this.sourceIncludesResolver.resolveInclude(file, include, visibleMacros)).isComplete()) {
                    LOGGER.info("Cannot locate header file for '{}' in source file '{}'. Assuming changed.", (Object)include.getAsSourceText(), (Object)file.getName());
                    if (isSourceFile || !IncrementalCompileFilesFactory.this.ignoreUnresolvedHeadersInDependencies) {
                        this.hasUnresolvedHeaders = true;
                        result = IncludeFileResolutionResult.UnresolvedMacroIncludes;
                    }
                }
                for (SourceIncludesResolver.IncludeFile includeFile : resolutionResult.getFiles()) {
                    this.existingHeaders.add(includeFile.getFile());
                    FileVisitResult includeVisitResult = this.visitFile(includeFile.getFile(), includeFile.getSnapshot(), visibleMacros, visited, false);
                    if (includeVisitResult.result.ordinal() > result.ordinal()) {
                        result = includeVisitResult.result;
                    }
                    includeVisitResult.collectDependencies(includedFileDirectives);
                    included.add(includeVisitResult);
                }
            }
            FileVisitResult visitResult = new FileVisitResult(file, result, fileDetails.state, fileDetails.directives, included, includedFileDirectives);
            if (result == IncludeFileResolutionResult.NoMacroIncludes) {
                fileDetails.results = visitResult;
            }
            return visitResult;
        }

        private List<File> getRemovedSources() {
            ArrayList<File> removed = new ArrayList<File>();
            for (File previousSource : this.previous.getSourceInputs()) {
                if (this.current.getSourceInputs().contains(previousSource)) continue;
                removed.add(previousSource);
            }
            return removed;
        }
    }
}

