/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.testing.TestFilter;

public class DefaultTestFilter
implements TestFilter {
    private Set<String> testNames = new HashSet<String>();
    private Set<String> commandLineTestNames = new HashSet<String>();
    private boolean failOnNoMatching = true;

    private void validateName(String name) {
        if (name == null || name.length() == 0) {
            throw new InvalidUserDataException("Selected test name cannot be null or empty.");
        }
    }

    @Override
    public TestFilter includeTestsMatching(String testNamePattern) {
        this.validateName(testNamePattern);
        this.testNames.add(testNamePattern);
        return this;
    }

    @Override
    public TestFilter includeTest(String className, String methodName) {
        this.validateName(className);
        if (methodName == null || methodName.trim().isEmpty()) {
            this.testNames.add(className + ".*");
        } else {
            this.testNames.add(className + "." + methodName);
        }
        return this;
    }

    @Override
    public void setFailOnNoMatchingTests(boolean failOnNoMatchingTests) {
        this.failOnNoMatching = failOnNoMatchingTests;
    }

    @Override
    public boolean isFailOnNoMatchingTests() {
        return this.failOnNoMatching;
    }

    @Override
    @Input
    public Set<String> getIncludePatterns() {
        return this.testNames;
    }

    @Override
    public TestFilter setIncludePatterns(String ... testNamePatterns) {
        for (String name : testNamePatterns) {
            this.validateName(name);
        }
        this.testNames = Sets.newHashSet((Object[])testNamePatterns);
        return this;
    }

    @Input
    public Set<String> getCommandLineIncludePatterns() {
        return this.commandLineTestNames;
    }

    public TestFilter setCommandLineIncludePatterns(Collection<String> testNamePatterns) {
        for (String name : testNamePatterns) {
            this.validateName(name);
        }
        this.commandLineTestNames.clear();
        this.commandLineTestNames.addAll(testNamePatterns);
        return this;
    }
}

