/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerServer;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerFactory;

public class NoIsolationWorkerFactory
implements WorkerFactory {
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker workTracker;
    private final InstantiatorFactory instantiatorFactory;
    private Instantiator actionInstantiator;

    public NoIsolationWorkerFactory(WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker workTracker, InstantiatorFactory instantiatorFactory) {
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.workTracker = workTracker;
        this.instantiatorFactory = instantiatorFactory;
    }

    public void setWorkerExecutor(WorkerExecutor workerExecutor) {
        DefaultServiceRegistry services = new DefaultServiceRegistry();
        services.add(WorkerExecutor.class, (Object)workerExecutor);
        this.actionInstantiator = this.instantiatorFactory.inject((ServiceRegistry)services);
    }

    public Worker getWorker(DaemonForkOptions forkOptions) {
        return new Worker(){

            public DefaultWorkResult execute(ActionExecutionSpec spec) {
                return this.execute(spec, NoIsolationWorkerFactory.this.workerLeaseRegistry.getCurrentWorkerLease(), NoIsolationWorkerFactory.this.buildOperationExecutor.getCurrentOperation());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DefaultWorkResult execute(final ActionExecutionSpec spec, WorkerLeaseRegistry.WorkerLease parentWorkerWorkerLease, final BuildOperationRef parentBuildOperation) {
                WorkerLeaseRegistry.WorkerLeaseCompletion workerLease = parentWorkerWorkerLease.startChild();
                try {
                    DefaultWorkResult defaultWorkResult = (DefaultWorkResult)NoIsolationWorkerFactory.this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<DefaultWorkResult>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public DefaultWorkResult call(BuildOperationContext context) {
                            DefaultWorkResult result;
                            try {
                                DefaultWorkerServer workerServer = new DefaultWorkerServer(NoIsolationWorkerFactory.this.actionInstantiator);
                                result = workerServer.execute(spec);
                            }
                            finally {
                                NoIsolationWorkerFactory.this.workTracker.waitForCompletion(NoIsolationWorkerFactory.this.buildOperationExecutor.getCurrentOperation(), false);
                            }
                            return result;
                        }

                        public BuildOperationDescriptor.Builder description() {
                            return BuildOperationDescriptor.displayName((String)spec.getDisplayName()).parent(parentBuildOperation);
                        }
                    });
                    return defaultWorkResult;
                }
                finally {
                    workerLease.leaseFinish();
                }
            }
        };
    }

    public IsolationMode getIsolationMode() {
        return IsolationMode.NONE;
    }
}

