(* (c) Microsoft Corporation 2005-2007.  *)

(*F# 
module Microsoft.FSharp.Compiler.UnicodeLexing
F#*)

(*----------------------------------------------------------------------------
 * Reading UTF-8 (signatures)
 *--------------------------------------------------------------------------*)
(*F# open System.IO F#*)

let usingUnicodeFileAsUTF8Lexbuf filename (codePage : int option) f =
(*IF-OCAML*)
  let is = open_in filename in
  try 
    let inlen = in_channel_length is in 
    let trybyte() = try Some(input_byte(is)) with End_of_file -> None in
    begin match trybyte(),trybyte() with
    | Some(0xff),Some(0xfe) 
    | Some(0xfe),Some(0xff)  ->
      failwith "This input file is encoded using the UTF-16 Unicode encoding. This tool only accepts UTF-8 encoded files. Try saving the file using the UTF-8 encoding."
    | _ -> seek_in is 0
    end;

    (* NOTE: This looks for the BOM (Byte Order Mark) that indicates we have UTF-8 file.  We can safely ignore this.  *)
    (* NOTE: Many UTF-8 files do not have this signature, but ones written by notepad.exe do.  *)
    (* For more on BOMs see for example http://www.unicode.org/faq/utf_bom.html#22 *)
    (* NOTE: We currently only accept ASCII or UTF-8 encodings.  *)
    begin match trybyte(),trybyte(),trybyte() with
    | Some(0xef),Some(0xbb),Some(0xbf) -> ()
    | _ -> seek_in is 0
    end;
    let res = f (Lexing.from_channel is) in 
    close_in is;
    res
  with e ->
    (close_in is;
     raise e
    )
(*ENDIF-OCAML*)
(*F#
 // The F# version of this function uses the .NET functionality to auto-detect the unicode encoding
 // It also uses Lexing.from_text_reader to present the bytes read to the lexer in UTF8 decoded form
  let stream  = new FileStream(filename,FileMode.Open,FileAccess.Read,FileShare.Read) in
  let reader = 
    match codePage with 
    | None -> new  StreamReader(stream,true)
    | Some n -> new  StreamReader(stream,System.Text.Encoding.GetEncoding(n)) in
   using reader (fun _ -> 
    f (Lexing.from_text_reader System.Text.Encoding.UTF8 (reader :> TextReader))
  )
F#*)
    
