(* (c) Microsoft Corporation 2005-2007.  *)

(* Rebind z,q,nums to implement ML-compatible library APIs *)

module Microsoft.FSharp.Compatibility.OCaml.Big_int
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

open Microsoft.FSharp.Math.BigInt

type big_int = bigint
let zero_big_int = zero
let unit_big_int = one
let minus_big_int    a b  = sub a b
let add_big_int      a b  = add a b
let succ_big_int     n    = add n one
let add_int_big_int  a b  = add (of_int a) b
let sub_big_int      a b  = sub a b
let pred_big_int     a    = sub a one
let mult_big_int     a b  = mul a b
let mult_int_big_int a b  = mul (of_int a) b
let square_big_int   a    = mul a a
//  let sqrt_big_int     a    = failwith "Implemented on demand. TODO"
let quomod_big_int   a b  = divmod a b
let div_big_int      a b  = div a b    
let mod_big_int      a b  = rem a b    
let gcd_big_int      a b  = hcf a b
let power_int_positive_int         x n = powi (of_int x) n
let power_big_int_positive_int     x n = powi  x         n
let power_int_positive_big_int     x n = pow  (of_int x) n
let power_big_int_positive_big_int x n = pow   x         n
let sign_big_int    x   = sign x
let compare_big_int x y = sign (sub x y)
let eq_big_int  x y = equal x y
let le_big_int  x y = lte   x y
let ge_big_int  x y = gte   x y
let lt_big_int  x y = lt    x y
let gt_big_int  x y = gt    x y
let max_big_int x y = max x y
let min_big_int x y = min x y
(* num_digits_big_int *)
let string_of_big_int x = to_string x
let big_int_of_string x = of_string x
let int_of_big_int  x    = to_int x
(* is_int_big_int *)
let big_int_of_int x    = of_int x
let float_of_big_int x  = to_float x
(* nat_of *)
(* of_nat *)
(* base_power_big_int *)
(* sys_big_int_of_string *)
(* round_futur_last_digit *)
(* approx_big_int *)

