//==========================================================================
// This file contains the definitions of primitive operations which can
// be used to implement a functional programming library for use with the
// F# compiler.  They are not typically for direct use from user code.
//
// LexBuffers are for use with automatically generated lexical analyzers,
// in particular those produced by 'fslex'.
//
// (c) Microsoft Corporation 2005-2007.
//=========================================================================

#light

/// Parsers generated by FsPars provide information from within parser
/// actions.  However that information is not available globally, but
/// rather is accessed via the functions available on the local
/// variable 
///    parseInformation : Microsoft.FSharp.Tools.FsYacc.IParseState

namespace Microsoft.FSharp.Tools.FsYacc

open Microsoft.FSharp.Core
open Microsoft.FSharp.Primitives
open Microsoft.FSharp.Tools.FsLex

type IParseState<'pos> = 
    interface
        abstract StartOfRHS: int -> 'pos
        abstract EndOfRHS  : int -> 'pos
        abstract StartOfLHS: 'pos
        abstract EndOfLHS  : 'pos
        abstract GetData   : int -> obj 
        abstract RaiseError<'b> : unit -> 'b 
    end

// Tables generated by fsyacc
type Tables<'tok,'pos> = 
  { reductions: (IParseState<'pos> -> obj) array ;
    end_of_input_tag: int;
    tagof: 'tok -> int;
    dataof: 'tok -> obj; 
    action_table_elements: byte[];
    action_table_row_offsets: byte[];
    reduction_nsyms: byte[];
    immediate_action: byte[];      
    gotos: byte[];
    gotos_row_offsets: byte[];
    nonterms: byte[];
    parse_error: string -> unit;
    tagof_error_term: int }
  with
      member Interpret : (LexBuffer<'pos,'char> -> 'tok) * LexBuffer<'pos,'char> * int -> obj 
  end

exception Accept of obj
exception RecoverableParseError

module ParseHelpers =
   val parse_error: string -> unit

