(*==========================================================================
 * (c) Microsoft Corporation 2005-2007. The interface to the module 
 * is similar to that found in versions of other ML implementations, 
 * but is not an exact match.  The type signatures in this interface
 * are an edited version of those generated automatically by running 
 * "bin\fsc.exe -i" on the implementation file.
 *=========================================================================*)

/// Basic operations on 3-dimensional arrays.  Only available for F# on .NET 2.0.
module Microsoft.FSharp.Collections.Array3
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.Operators


#if CLI_AT_MOST_1_1
#else
/// Create an array whose elements are all initially the given value
val create: len1:int -> len2:int -> len3:int -> 'a -> 'a[,,]

/// Create an array given the dimensions and a generator function to compute the elements.
val init: int -> int -> int -> (int -> int -> int -> 'a) -> 'a[,,]

/// Fetch an element from a 3D array.  You can also use the syntax 'arr.[idx1,idx2,idx3]'
val get: 'a[,,] -> idx1:int -> idx2:int -> idx3:int -> 'a

/// Apply the given function to each element of the array. 
val iter: ('a -> unit) -> 'a[,,] -> unit

/// Apply the given function to each element of the array.  The integer indicies passed to the
/// function indicates the index of element.
val iteri: (int -> int -> int -> 'a -> unit) -> 'a[,,] -> unit

/// Return the length of an array in the first dimension  
val length1: 'a[,,] -> int

/// Return the length of an array in the second dimension  
val length2: 'a[,,] -> int

/// Return the length of an array in the third dimension  
val length3: 'a[,,] -> int

[<System.Obsolete("Consider using Array3.create instead")>]
val make: int -> int -> int -> 'a -> 'a[,,]

/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array.
///
/// For non-zero-based arrays the basing on an input array will be propogated to the output
/// array.
val map: ('a -> 'b) -> 'a[,,] -> 'b[,,]

/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array. The integer indices passed to the
/// function indicates the element being transformed.
///
/// For non-zero-based arrays the basing on an input array will be propogated to the output
/// array.
val mapi: (int -> int -> int -> 'a -> 'b) -> 'a[,,] -> 'b[,,]

/// Set the value of an element in an array.  You can also 
/// use the syntax 'arr.[idx1,idx2,idx3] &lt;- e'.
val set: 'a[,,] -> idx1:int -> idx2:int -> idx3:int -> 'a -> unit

/// Create an array where the entries are initially the
/// a "default" value. For .NET reference types this will
/// be "null".  For other types behaviour is undefined if 
/// you access an entry of the array before setting it.
///
/// See notes on the Array3 module re. zero-basing.
val zero_create: int -> int -> int -> 'a[,,]
#endif
