(* (c) Microsoft Corporation. All rights reserved  *)

(*F# 
module Microsoft.Research.AbstractIL.Internal.Pmap 
F#*)

type ('key,'a) t (*F# = Map.t<'key,'a> F#*)
val empty : ('key,'a) t
val is_empty : ('key,'a) t -> bool
val add : 'key -> 'a -> ('key,'a) t -> ('key,'a) t
val find : 'key -> ('key,'a) t -> 'a
val tryfind : 'key -> ('key,'a) t -> 'a option
val tryfind_multi : 'key -> ('key,'a list) t -> 'a list
val exists : ('key -> 'a -> bool) -> ('key,'a) t -> bool
val remove : 'key -> ('key,'a) t -> ('key,'a) t
val mem : 'key -> ('key,'a) t -> bool
val iter : ('key -> 'a -> unit) -> ('key,'a) t -> unit
val map : ('a -> 'b) -> ('key,'a) t -> ('key,'b) t
val filter : ('key -> 'a -> bool) -> ('key,'a) t -> ('key,'a) t
val mapi : ('key -> 'a -> 'b) -> ('key,'a) t -> ('key,'b) t
val fold : ('key -> 'a -> 'b -> 'b) -> ('key,'a) t -> 'b -> 'b
