// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 

#light 

// This program demonstrates using a classic COM object from F#. 

#r "QuartzTypeLib.dll"

open System
open System.Runtime.InteropServices

// Collects the filename of an AVI to show then create an  
// instance of the Quartz classic COM object.  To show the AVI, the program calls 
// RenderFile and Run on IMediaControl.  Quartz uses its own thread and window 
// to display the AVI.  The main thread blocks on a ReadLine until the user hits 
// enter.  

let processOneFile file =
    let mc = new QuartzTypeLib.FilgraphManagerClass() in  // QuartzTypeLib.IMediaControl 
    mc.RenderFile(file);
    mc.Run();
    Console.WriteLine("Hit Enter to continue/exit.");
    Console.ReadLine()  |> ignore

// Use this if using F# Interactive:

#if INTERACTIVE
processOneFile @"c:\WINDOWS\clock.avi"
#endif

#if COMPILED
[<EntryPoint; STAThread>]
let main(argv) = 
   if argv.Length = 1 then Console.WriteLine ("play [file1.avi [file2.avi ...] ]");
   Arg.parse [] processOneFile "play [file1.avi [file2.avi ...] ]"
   
#endif

