// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 

// Echo Client: connects to a server (presumed to be on the local host) and 
// sends it data, presuming it to be an echo server which bounces data back.  

#light

open System.Net
open System.Net.Sockets

[<EntryPoint>]
let main(argv) = 
    try 
        printfn "client created...";
        if Array.length argv < 2 then (Printf.eprintf "usage: client <port>"; exit 1); 
        let csock = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.IP) 
        let port = int argv.[1]
        printfn "client connecting on port %d..." port;
        csock.Connect(new System.Net.IPEndPoint(System.Net.IPAddress.Parse "127.0.0.1", port));
        let buf = Bytearray.create 64
        while (true) do 
            let data = System.Console.In.ReadLine() 
            if data.Length > 0 then 
                let dataToSend = System.Text.Encoding.ASCII.GetBytes(data) 
                let n = csock.Send(dataToSend) 
                printfn "client wrote %d bytes" n;
                let n = csock.Receive(buf) 
                printfn "client read: %s" (System.Text.Encoding.ASCII.GetString(buf,0,n));
        done;
        printfn "client closing...";
        csock.Close()

    with 
        | :? Sockets.SocketException 
        | :? System.IO.IOException -> 

            printfn "server gone!"


