// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Int32 = 

    let compare (x:int32) y = compare x y

    let zero = 0
    let one = 1
    let minus_one = (-1)
    let neg (x:int32) =  -x
    let add (x:int32) (y:int32) = x + y
    let sub (x:int32) (y:int32) = x - y
    let mul (x:int32) (y:int32) = x * y
    let div (x:int32) (y:int32) = x / y
    let rem (x:int32) (y:int32) = x % y
    let succ (x:int32) = x + 1
    let pred (x:int32) = x - 1
    let abs (x:int32) = if x < zero then neg x else x
    let max_int = 0x7FFFFFFF
    let min_int = 0x80000000
    let logand (x:int32) (y:int32) = x &&& y
    let logor (x:int32) (y:int32) = x ||| y
    let logxor (x:int32) (y:int32) = x ^^^ y
    let lognot (x:int32) = ~~~ x
    let shift_left (x:int32) (n:int) =  x <<< n
    let shift_right (x:int32) (n:int) =  x >>> n

    let of_uint32 (f:uint32) =  (# "conv.i4" f : int32 #)
    let to_uint32 (x:int32) =  (# "conv.u4" x : uint32 #)

    let shift_right_logical (x:int32) (n:int) =  of_uint32 (to_uint32 x >>> n)
    let of_int (n:int) =  n
    let to_int (x:int32) = x
    let of_float (f:float) =  (# "conv.i4" f : int32 #)
    let to_float (x:int32) =  (# "conv.r8" x : float #)

    let of_float32 (f:float32) =  (# "conv.i4" f : int32 #)
    let to_float32 (x:int32) =  (# "conv.r4" x : float32 #)

    let of_int64 (f:int64) =  (# "conv.i4" f : int32 #)
    let to_int64 (x:int32) =  (# "conv.i8" x : int64 #)

    let of_nativeint (f:nativeint) =  (# "conv.i4" f : int32 #) 
    let to_nativeint (x:int32) =  (# "conv.u" x : nativeint #)


    let of_string (s:string) = 
      try
        let l = s.Length in 
        let p = 0 in 
        let p,sign = if (l >= p + 1 && s.[p] = '-') then 1,(-1) else 0,1 in 
        let p,specifier = 
           if (l >= p + 2 && s.[p] = '0' && (let c = System.Char.ToLower s.[p+1] in c = 'x' || c = 'o' || c = 'b')) 
           then p+2,s.[p+1] 
           else p,'d' in 
        if p >= l then raise (new System.FormatException()) 
        else
            match System.Char.ToLower specifier with 
            | 'x' -> 
              sign * System.Int32.Parse(s.[p..], System.Globalization.NumberStyles.AllowHexSpecifier,System.Globalization.CultureInfo.InvariantCulture)
            | 'b' -> 
              let rec parse n acc = 
                 if n < l then parse (n+1) (acc * 2 + (match s.[n] with '0' -> 0 | '1' -> 1 | _ -> raise (new System.FormatException()))) 
                 else acc in
              sign * parse p 0
            | 'o' -> 
              let rec parse n acc = 
                  if n < l then parse (n+1) (acc * 8 + (let c = s.[n] in 
                                                        if c >= '0' && c <= '7' then System.Convert.ToInt32(c) - System.Convert.ToInt32('0') 
                                                        else raise (new System.FormatException()))) 
                  else acc in
              sign * parse p 0
            | _ -> 
              System.Int32.Parse(s, System.Globalization.CultureInfo.InvariantCulture)
      with :? System.FormatException -> failwith "int_of_string"

    let to_string (x:int32) = (box x).ToString()

    let bits_of_float32 (x:float32) = System.BitConverter.ToInt32(System.BitConverter.GetBytes(x),0)
    let float32_of_bits (x:int32) = System.BitConverter.ToSingle(System.BitConverter.GetBytes(x),0)

    let float32_to_float (x:float32) = (# "conv.r8" x : float #)
    let float_to_float32 (x:float) = (# "conv.r4" x : float32 #)

    let float_of_bits x = float32_to_float (float32_of_bits x)
    let bits_of_float x = bits_of_float32 (float_to_float32 x)
