/*
 * Decompiled with CFR 0.152.
 */
package fanx.tools;

import fan.sys.Env;
import fan.sys.Err;
import fan.sys.List;
import fan.sys.Method;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.test.Test;
import fanx.tools.Fan;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Fant {
    int testCount = 0;
    int methodCount = 0;
    int totalVerifyCount = 0;
    int failures = 0;
    ArrayList failureNames = new ArrayList();

    public int test(String[] stringArray, boolean bl) {
        Sys.boot();
        long l = System.currentTimeMillis();
        for (int i = 0; i < stringArray.length; ++i) {
            this.test(stringArray[i], bl);
        }
        long l2 = System.currentTimeMillis();
        System.out.println();
        System.out.println("Time: " + (l2 - l) + "ms");
        System.out.println();
        if (this.failureNames.size() > 0) {
            System.out.println("Failed:");
            for (int i = 0; i < this.failureNames.size(); ++i) {
                System.out.println("  " + this.failureNames.get(i));
            }
            System.out.println();
        }
        System.out.println("***");
        System.out.println("*** " + (this.failures == 0 ? "All tests passed!" : this.failures + " FAILURES") + " [" + this.testCount + " tests, " + this.methodCount + " methods, " + this.totalVerifyCount + " verifies] ");
        System.out.println("***");
        return this.failures;
    }

    public void test(String string, boolean bl) {
        if (string.equals("*")) {
            List list = Pod.list();
            for (int i = 0; i < list.sz(); ++i) {
                Pod pod = (Pod)list.get(i);
                this.test(pod.name(), bl);
            }
            return;
        }
        if (string.equals("sys") || string.startsWith("sys::")) {
            System.out.println();
            string = string.equals("sys") ? "" : string.substring(5);
            if (!Test.test(string)) {
                ++this.failures;
            }
            this.totalVerifyCount += Test.totalVerified;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":.");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "*";
        String string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "*";
        System.out.println();
        Pod pod = Pod.find(string2, true);
        Type[] typeArray = this.tests(pod, string3);
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            Method[] methodArray = this.methods(type, string4);
            for (int j = 0; j < methodArray.length; ++j) {
                String string5 = type.qname() + "." + methodArray[j].name();
                System.out.println("-- Run:  " + string5 + "...");
                System.out.flush();
                int n = this.runTest(typeArray[i], methodArray[j]);
                if (n < 0) {
                    ++this.failures;
                    this.failureNames.add(string5);
                    continue;
                }
                System.out.println("   Pass: " + string5 + " [" + n + "]");
                ++this.methodCount;
                this.totalVerifyCount += n;
            }
            ++this.testCount;
        }
    }

    private Type[] tests(Pod pod, String string) {
        if (!string.equals("*")) {
            return new Type[]{pod.type(string, true)};
        }
        List list = pod.types();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < list.sz(); ++i) {
            Type type = (Type)list.get(i);
            if (!type.is(Sys.TestType) || type.isAbstract()) continue;
            arrayList.add(type);
        }
        return arrayList.toArray(new Type[arrayList.size()]);
    }

    private Method[] methods(Type type, String string) {
        if (!string.equals("*")) {
            return new Method[]{type.method(string, true)};
        }
        List list = type.methods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < list.sz(); ++i) {
            Method method = (Method)list.get(i);
            if (!method.name().startsWith("test") || method.isAbstract()) continue;
            arrayList.add(method);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runTest(Type type, Method method) {
        Method method2 = type.method("setup", true);
        Method method3 = type.method("teardown", true);
        fan.sys.Test test = null;
        List list = null;
        try {
            test = (fan.sys.Test)type.make();
            list = new List(Sys.ObjType, new Object[]{test});
        }
        catch (Throwable throwable) {
            System.out.println();
            System.out.println("ERROR: Cannot make test " + type);
            if (throwable instanceof Err) {
                ((Err)throwable).trace();
            } else {
                throwable.printStackTrace();
            }
            return -1;
        }
        try {
            test.curTestMethod = method;
            method2.callList(list);
            method.callList(list);
            int n = test.verifyCount;
            return n;
        }
        catch (Throwable throwable) {
            System.out.println();
            System.out.println("TEST FAILED");
            if (throwable instanceof Err) {
                ((Err)throwable).trace();
            } else {
                throwable.printStackTrace();
            }
            int n = -1;
            return n;
        }
        finally {
            try {
                if (list != null) {
                    method3.callList(list);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof Err) {
                    ((Err)throwable).trace();
                }
                throwable.printStackTrace();
            }
            test.curTestMethod = null;
        }
    }

    public int run(String[] stringArray) {
        try {
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray.length == 0) {
                this.help();
                return -1;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].intern();
                if (string.length() == 0) continue;
                if (string == "-help" || string == "-h" || string == "-?") {
                    this.help();
                    return -1;
                }
                if (string == "-version") {
                    Fan.version("Fantom Test");
                    return -1;
                }
                if (string == "-v") {
                    bl2 = true;
                    fan.sys.Test.verbose = true;
                    Test.verbose = true;
                    continue;
                }
                if (string == "-all") {
                    arrayList.add("*");
                    continue;
                }
                if (string.charAt(0) == '-') {
                    System.out.println("WARNING: Unknown option " + string);
                    continue;
                }
                arrayList.add(string);
            }
            if (arrayList.size() == 0) {
                this.help();
                return -1;
            }
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            return this.test(stringArray2, bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return -1;
        }
    }

    void help() {
        System.out.println("Fantom Test");
        System.out.println("Usage:");
        System.out.println("  fant [options] -all");
        System.out.println("  fant [options] <pod> [pod]*");
        System.out.println("  fant [options] <pod>::<test>");
        System.out.println("  fant [options] <pod>::<test>.<method>");
        System.out.println("Note:");
        System.out.println("  You can use * to indicate wildcard for all pods");
        System.out.println("Options:");
        System.out.println("  -help, -h, -?  print usage help");
        System.out.println("  -version       print version");
        System.out.println("  -v             verbose mode");
        System.out.println("  -all           test all pods");
    }

    public static void fanMain() throws Exception {
        List list = Env.cur().args();
        Fant.main((String[])list.toArray(new String[list.sz()]));
    }

    public static void main(String[] stringArray) throws Exception {
        System.exit(new Fant().run(stringArray));
    }
}

