/*
 * Decompiled with CFR 0.152.
 */
package fanx.interop;

import fan.sys.Err;
import fan.sys.FanInt;
import fan.sys.InStream;
import fan.sys.Map;
import fan.sys.MapType;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.SysOutStream;
import fan.sys.Type;
import fanx.util.FanUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Interop {
    public static Class getClass(Object object) {
        return object.getClass();
    }

    public static Type toFan(Class clazz) {
        return FanUtil.toFanType(clazz, true);
    }

    public static Class toJava(Type type) {
        return type.toClass();
    }

    public static Err toFan(Throwable throwable) {
        return Err.make(throwable);
    }

    public static Throwable toJava(Err err) {
        return err.toJava();
    }

    public static InStream toFan(InputStream inputStream) {
        return SysInStream.make(inputStream, FanInt.Chunk);
    }

    public static InStream toFan(InputStream inputStream, long l) {
        return SysInStream.make(inputStream, l);
    }

    public static OutStream toFan(OutputStream outputStream) {
        return SysOutStream.make(outputStream, FanInt.Chunk);
    }

    public static OutStream toFan(OutputStream outputStream, long l) {
        return SysOutStream.make(outputStream, l);
    }

    public static InputStream toJava(InStream inStream) {
        return SysInStream.java(inStream);
    }

    public static OutputStream toJava(OutStream outStream) {
        return SysOutStream.java(outStream);
    }

    public static fan.sys.List toFan(List list) {
        return Interop.toFan(list.iterator(), Sys.ObjType.toNullable());
    }

    public static fan.sys.List toFan(List list, Type type) {
        return Interop.toFan(list.iterator(), type);
    }

    public static fan.sys.List toFan(Enumeration enumeration) {
        return Interop.toFan(enumeration, Sys.ObjType.toNullable());
    }

    public static fan.sys.List toFan(Enumeration enumeration, Type type) {
        fan.sys.List list = new fan.sys.List(type);
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static fan.sys.List toFan(Iterator iterator) {
        return Interop.toFan(iterator, Sys.ObjType.toNullable());
    }

    public static fan.sys.List toFan(Iterator iterator, Type type) {
        fan.sys.List list = new fan.sys.List(type);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Map toFan(HashMap hashMap) {
        return new Map(new MapType(Sys.ObjType, Sys.ObjType.toNullable()), hashMap);
    }

    public static Map toFan(HashMap hashMap, Type type) {
        return new Map((MapType)type, hashMap);
    }

    public static HashMap toJava(Map map) {
        return map.toJava();
    }
}

