/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fanx.fcode.FPod;
import fanx.fcode.FStore;
import fanx.util.FanUtil;
import java.io.IOException;

public final class FTypeRef {
    public static final int NULLABLE = 1;
    public static final int GENERIC_INSTANCE = 2;
    public static final int SYS_OBJ = 4;
    public static final int SYS_BOOL = 8;
    public static final int SYS_INT = 16;
    public static final int SYS_FLOAT = 32;
    public static final int SYS_ERR = 64;
    public static final int SYS_LIST = 128;
    public static final int PRIMITIVE = 65280;
    public static final int PRIMITIVE_BOOL = 256;
    public static final int PRIMITIVE_BYTE = 512;
    public static final int PRIMITIVE_SHORT = 1024;
    public static final int PRIMITIVE_CHAR = 2048;
    public static final int PRIMITIVE_INT = 4096;
    public static final int PRIMITIVE_LONG = 8192;
    public static final int PRIMITIVE_FLOAT = 16384;
    public static final int PRIMITIVE_DOUBLE = 32768;
    public static final int PRIMITIVE_ARRAY = 0xFF0000;
    public static final int ARRAY_BOOL = 65536;
    public static final int ARRAY_BYTE = 131072;
    public static final int ARRAY_SHORT = 262144;
    public static final int ARRAY_CHAR = 524288;
    public static final int ARRAY_INT = 0x100000;
    public static final int ARRAY_LONG = 0x200000;
    public static final int ARRAY_FLOAT = 0x400000;
    public static final int ARRAY_DOUBLE = 0x800000;
    public static final int VOID = 86;
    public static final int BOOL = 90;
    public static final int BYTE = 66;
    public static final int SHORT = 83;
    public static final int CHAR = 67;
    public static final int INT = 73;
    public static final int LONG = 74;
    public static final int FLOAT = 70;
    public static final int DOUBLE = 68;
    public static final int OBJ = 65;
    public final int id;
    public final String podName;
    public final String typeName;
    public final int mask;
    public final int stackType;
    public final String signature;
    private String jname;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FTypeRef(int n, String string, String string2, String string3) {
        this.id = n;
        this.podName = string;
        this.typeName = string2;
        int n2 = 0;
        int n3 = 65;
        boolean bl = false;
        if (string3.endsWith("?")) {
            n2 |= 1;
            bl = true;
        }
        if (string3.length() > 1) {
            n2 |= 2;
        }
        if (string.startsWith("[java]")) {
            if (string.length() == 6) {
                if (string2.equals("int")) {
                    n2 |= 0x1000;
                    n3 = 73;
                } else if (string2.equals("char")) {
                    n2 |= 0x800;
                    n3 = 67;
                } else if (string2.equals("byte")) {
                    n2 |= 0x200;
                    n3 = 66;
                } else if (string2.equals("short")) {
                    n2 |= 0x400;
                    n3 = 83;
                } else {
                    if (!string2.equals("float")) throw new IllegalStateException(string2);
                    n2 |= 0x4000;
                    n3 = 70;
                }
            } else if (string.equals("[java]fanx.interop")) {
                if (string2.equals("BooleanArray")) {
                    n2 |= 0x10000;
                } else if (string2.equals("ByteArray")) {
                    n2 |= 0x20000;
                } else if (string2.equals("ShortArray")) {
                    n2 |= 0x40000;
                } else if (string2.equals("CharArray")) {
                    n2 |= 0x80000;
                } else if (string2.equals("IntArray")) {
                    n2 |= 0x100000;
                } else if (string2.equals("LongArray")) {
                    n2 |= 0x200000;
                } else if (string2.equals("FloatArray")) {
                    n2 |= 0x400000;
                } else if (string2.equals("DoubleArray")) {
                    n2 |= 0x800000;
                }
            }
        } else if (string.equals("sys")) {
            switch (string2.charAt(0)) {
                case 'B': {
                    if (!string2.equals("Bool")) break;
                    n2 |= 8;
                    if (bl) break;
                    n2 |= 0x100;
                    n3 = 90;
                    break;
                }
                case 'E': {
                    if (!string2.equals("Err")) break;
                    n2 |= 0x40;
                    break;
                }
                case 'F': {
                    if (!string2.equals("Float")) break;
                    n2 |= 0x20;
                    if (bl) break;
                    n2 |= 0x8000;
                    n3 = 68;
                    break;
                }
                case 'I': {
                    if (!string2.equals("Int")) break;
                    n2 |= 0x10;
                    if (bl) break;
                    n2 |= 0x2000;
                    n3 = 74;
                    break;
                }
                case 'L': {
                    if (!string2.equals("List")) break;
                    n2 |= 0x80;
                    break;
                }
                case 'O': {
                    if (!string2.equals("Obj")) break;
                    n2 |= 4;
                    break;
                }
                case 'V': {
                    if (!string2.equals("Void")) break;
                    n3 = 86;
                }
            }
        }
        this.mask = n2;
        this.stackType = n3;
        this.signature = this.isGenericInstance() ? string3 : string + "::" + string2 + string3;
    }

    public boolean isNullable() {
        return (this.mask & 1) != 0;
    }

    public boolean isGenericInstance() {
        return (this.mask & 2) != 0;
    }

    public boolean isRef() {
        return this.stackType == 65;
    }

    public boolean isObj() {
        return (this.mask & 4) != 0;
    }

    public boolean isBool() {
        return (this.mask & 8) != 0;
    }

    public boolean isInt() {
        return (this.mask & 0x10) != 0;
    }

    public boolean isFloat() {
        return (this.mask & 0x20) != 0;
    }

    public boolean isErr() {
        return (this.mask & 0x40) != 0;
    }

    public boolean isList() {
        return (this.mask & 0x80) != 0;
    }

    public boolean isFFI() {
        return this.podName.startsWith("[java]");
    }

    public boolean isWide() {
        return this.stackType == 74 || this.stackType == 68;
    }

    public static boolean isWide(int n) {
        return n == 74 || n == 68;
    }

    public String jname() {
        if (this.jname == null) {
            this.jname = FanUtil.toJavaTypeSig(this.podName, this.typeName, this.isNullable());
        }
        return this.jname;
    }

    public String jnameBoxed() {
        if (this.stackType == 65) {
            return this.jname();
        }
        if (this.isPrimitiveBool()) {
            return "java/lang/Boolean";
        }
        if (this.isPrimitiveLong()) {
            return "java/lang/Long";
        }
        if (this.isPrimitiveDouble()) {
            return "java/lang/Double";
        }
        throw new IllegalStateException(this.signature);
    }

    public String jimpl() {
        return FanUtil.toJavaImplSig(this.jname());
    }

    public String jsig() {
        String string = this.jname();
        if (string.length() == 1 || string.charAt(0) == '[') {
            return string;
        }
        return "L" + string + ";";
    }

    public void jsig(StringBuilder stringBuilder) {
        String string = this.jname();
        if (string.length() == 1 || string.charAt(0) == '[') {
            stringBuilder.append(string);
        } else {
            stringBuilder.append('L').append(string).append(';');
        }
    }

    public String toString() {
        return this.signature;
    }

    public boolean isPrimitive() {
        return (this.mask & 0xFF00) != 0;
    }

    public boolean isPrimitiveBool() {
        return (this.mask & 0x100) != 0;
    }

    public boolean isPrimitiveByte() {
        return (this.mask & 0x200) != 0;
    }

    public boolean isPrimitiveShort() {
        return (this.mask & 0x400) != 0;
    }

    public boolean isPrimitiveChar() {
        return (this.mask & 0x800) != 0;
    }

    public boolean isPrimitiveInt() {
        return (this.mask & 0x1000) != 0;
    }

    public boolean isPrimitiveLong() {
        return (this.mask & 0x2000) != 0;
    }

    public boolean isPrimitiveFloat() {
        return (this.mask & 0x4000) != 0;
    }

    public boolean isPrimitiveDouble() {
        return (this.mask & 0x8000) != 0;
    }

    public boolean isPrimitiveIntLike() {
        int n = 7680;
        return (this.mask & n) != 0;
    }

    public boolean isPrimitiveArray() {
        return (this.mask & 0xFF0000) != 0;
    }

    public int arrayOfStackType() {
        switch (this.mask & 0xFF0000) {
            case 65536: {
                return 90;
            }
            case 131072: {
                return 66;
            }
            case 262144: {
                return 83;
            }
            case 524288: {
                return 67;
            }
            case 0x100000: {
                return 73;
            }
            case 0x200000: {
                return 74;
            }
            case 0x400000: {
                return 70;
            }
            case 0x800000: {
                return 68;
            }
        }
        throw new IllegalStateException(this.toString());
    }

    public static FTypeRef read(int n, FStore.Input input) throws IOException {
        FPod fPod = input.fpod;
        String string = fPod.name(input.u2());
        String string2 = fPod.name(input.u2());
        String string3 = input.utf();
        return new FTypeRef(n, string, string2, string3);
    }
}

