/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Err;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.File;
import fan.sys.IndexErr;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.MimeType;
import fan.sys.NameErr;
import fan.sys.ParseErr;
import fan.sys.Range;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnresolvedErr;
import fan.sys.UriScheme;
import fanx.serial.Literal;
import fanx.serial.ObjEncoder;
import fanx.util.OpUtil;
import java.util.Iterator;
import java.util.Map;

public final class Uri
extends FanObj
implements Literal {
    static final byte[] charMap;
    static final boolean[] nameMap;
    static final byte[] delimEscMap;
    static final int SCHEME = 1;
    static final int USER = 2;
    static final int HOST = 4;
    static final int PATH = 8;
    static final int QUERY = 16;
    static final int FRAG = 32;
    static final int DIGIT = 64;
    static final int HEX = 128;
    static final Range parentRange;
    public static final Uri defVal;
    final String str;
    final String scheme;
    final String userInfo;
    final String host;
    final Long port;
    final List path;
    final String pathStr;
    final Map query;
    final String queryStr;
    final String frag;
    String encoded;

    public static Uri fromStr(String string) {
        return Uri.fromStr(string, true);
    }

    public static Uri fromStr(String string, boolean bl) {
        try {
            return new Uri(new Decoder(string, false).decode());
        }
        catch (ParseErr parseErr) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Uri", string, parseErr.msg());
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Uri", string);
        }
    }

    public static Uri decode(String string) {
        return Uri.decode(string, true);
    }

    public static Uri decode(String string, boolean bl) {
        try {
            return new Uri(new Decoder(string, true).decode());
        }
        catch (ParseErr parseErr) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Uri", string, parseErr.msg());
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Uri", string);
        }
    }

    public static Map decodeQuery(String string) {
        try {
            return new Decoder(string, true).decodeQuery();
        }
        catch (ArgErr argErr) {
            throw ArgErr.make("Invalid Uri query: `" + string + "`: " + argErr.msg());
        }
        catch (Exception exception) {
            throw ArgErr.make("Invalid Uri query: `" + string + "`");
        }
    }

    public static String encodeQuery(Map map) {
        StringBuilder stringBuilder = new StringBuilder(256);
        Iterator iterator = map.keysIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            Uri.encodeQueryStr(stringBuilder, string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            Uri.encodeQueryStr(stringBuilder, string2);
        }
        return stringBuilder.toString();
    }

    static void encodeQueryStr(StringBuilder stringBuilder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0080' && (charMap[c] & 0x10) != 0 && (delimEscMap[c] & 0x10) == 0) {
                stringBuilder.append(c);
                continue;
            }
            Uri.percentEncodeChar(stringBuilder, c);
        }
    }

    private Uri(Sections sections) {
        this.scheme = sections.scheme;
        this.userInfo = sections.userInfo;
        this.host = sections.host;
        this.port = sections.port;
        this.pathStr = sections.pathStr;
        this.path = sections.path.ro();
        this.queryStr = sections.queryStr;
        this.query = sections.query.ro();
        this.frag = sections.frag;
        this.str = sections.str != null ? sections.str : new Encoder(this, false).encode();
    }

    static void percentEncodeChar(StringBuilder stringBuilder, int n) {
        if (n <= 127) {
            Uri.percentEncodeByte(stringBuilder, n);
        } else if (n > 2047) {
            Uri.percentEncodeByte(stringBuilder, 0xE0 | n >> 12 & 0xF);
            Uri.percentEncodeByte(stringBuilder, 0x80 | n >> 6 & 0x3F);
            Uri.percentEncodeByte(stringBuilder, 0x80 | n >> 0 & 0x3F);
        } else {
            Uri.percentEncodeByte(stringBuilder, 0xC0 | n >> 6 & 0x1F);
            Uri.percentEncodeByte(stringBuilder, 0x80 | n >> 0 & 0x3F);
        }
    }

    static void percentEncodeByte(StringBuilder stringBuilder, int n) {
        stringBuilder.append('%');
        int n2 = n >> 4 & 0xF;
        int n3 = n & 0xF;
        stringBuilder.append((char)(n2 < 10 ? 48 + n2 : 65 + (n2 - 10)));
        stringBuilder.append((char)(n3 < 10 ? 48 + n3 : 65 + (n3 - 10)));
    }

    public final boolean equals(Object object) {
        if (object instanceof Uri) {
            return this.str.equals(((Uri)object).str);
        }
        return false;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public long hash() {
        return FanStr.hash(this.str);
    }

    public String toStr() {
        return this.str;
    }

    public String toLocale() {
        return this.str;
    }

    public void encode(ObjEncoder objEncoder) {
        objEncoder.wStrLiteral(this.str, '`');
    }

    public Type typeof() {
        return Sys.UriType;
    }

    public String encode() {
        String string = this.encoded;
        if (string != null) {
            return string;
        }
        this.encoded = new Encoder(this, true).encode();
        return this.encoded;
    }

    public boolean isAbs() {
        return this.scheme != null;
    }

    public boolean isRel() {
        return this.scheme == null;
    }

    public boolean isDir() {
        String string;
        int n;
        return this.pathStr != null && (n = (string = this.pathStr).length()) > 0 && string.charAt(n - 1) == '/';
    }

    public String scheme() {
        return this.scheme;
    }

    public String auth() {
        if (this.host == null) {
            return null;
        }
        if (this.port == null) {
            if (this.userInfo == null) {
                return this.host;
            }
            return this.userInfo + '@' + this.host;
        }
        if (this.userInfo == null) {
            return this.host + ':' + this.port;
        }
        return this.userInfo + '@' + this.host + ':' + this.port;
    }

    public String host() {
        return this.host;
    }

    public String userInfo() {
        return this.userInfo;
    }

    public Long port() {
        return this.port;
    }

    public final String path(int n) {
        return (String)this.path.get(n);
    }

    public List path() {
        return this.path;
    }

    public String pathStr() {
        return this.pathStr;
    }

    public boolean isPathAbs() {
        if (this.pathStr == null || this.pathStr.length() == 0) {
            return false;
        }
        return this.pathStr.charAt(0) == '/';
    }

    public boolean isPathOnly() {
        return this.scheme == null && this.host == null && this.port == null && this.userInfo == null && this.queryStr == null && this.frag == null;
    }

    public String name() {
        if (this.path.sz() == 0) {
            return "";
        }
        return (String)this.path.last();
    }

    public String basename() {
        String string = this.name();
        int n = string.lastIndexOf(46);
        if (n < 2) {
            if (n < 0) {
                return string;
            }
            if (string.equals(".")) {
                return string;
            }
            if (string.equals("..")) {
                return string;
            }
        }
        return string.substring(0, n);
    }

    public String ext() {
        String string = this.name();
        int n = string.lastIndexOf(46);
        if (n < 2) {
            if (n < 0) {
                return null;
            }
            if (string.equals(".")) {
                return null;
            }
            if (string.equals("..")) {
                return null;
            }
        }
        return string.substring(n + 1);
    }

    public MimeType mimeType() {
        if (this.isDir()) {
            return MimeType.dir;
        }
        return MimeType.forExt(this.ext());
    }

    public Map query() {
        return this.query;
    }

    public String queryStr() {
        return this.queryStr;
    }

    public String frag() {
        return this.frag;
    }

    public Uri parent() {
        if (this.path.sz() == 0) {
            return null;
        }
        if (this.path.sz() == 1 && !this.isPathAbs() && !this.isDir()) {
            return null;
        }
        return this.slice(parentRange, false);
    }

    public Uri pathOnly() {
        if (this.pathStr == null) {
            throw Err.make("Uri has no path: " + this);
        }
        if (this.scheme == null && this.userInfo == null && this.host == null && this.port == null && this.queryStr == null && this.frag == null) {
            return this;
        }
        Sections sections = new Sections();
        sections.path = this.path;
        sections.pathStr = this.pathStr;
        sections.query = Uri.emptyQuery();
        sections.str = this.pathStr;
        return new Uri(sections);
    }

    public Uri getRange(Range range) {
        return this.slice(range, false);
    }

    public Uri getRangeToPathAbs(Range range) {
        return this.slice(range, true);
    }

    private Uri slice(Range range, boolean bl) {
        boolean bl2;
        if (this.pathStr == null) {
            throw Err.make("Uri has no path: " + this);
        }
        int n = this.path.sz();
        int n2 = range.start(n);
        int n3 = range.end(n);
        int n4 = n3 - n2 + 1;
        if (n4 < 0) {
            throw IndexErr.make(range);
        }
        boolean bl3 = n2 == 0;
        boolean bl4 = bl2 = n3 == n - 1;
        if (bl3 && bl2 && (!bl || this.isPathAbs())) {
            return this;
        }
        Sections sections = new Sections();
        sections.path = this.path.getRange(range);
        StringBuilder stringBuilder = new StringBuilder(this.pathStr.length());
        if (bl3 && this.isPathAbs() || bl) {
            stringBuilder.append('/');
        }
        for (int i = 0; i < sections.path.sz(); ++i) {
            if (i > 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append(sections.path.get(i));
        }
        if (sections.path.sz() > 0 && (!bl2 || this.isDir())) {
            stringBuilder.append('/');
        }
        sections.pathStr = stringBuilder.toString();
        if (bl3) {
            sections.scheme = this.scheme;
            sections.userInfo = this.userInfo;
            sections.host = this.host;
            sections.port = this.port;
        }
        if (bl2) {
            sections.queryStr = this.queryStr;
            sections.query = this.query;
            sections.frag = this.frag;
        } else {
            sections.query = Uri.emptyQuery();
        }
        if (!bl3 && !bl2) {
            sections.str = sections.pathStr;
        }
        return new Uri(sections);
    }

    public Uri relTo(Uri uri) {
        int n;
        if (!(OpUtil.compareEQ((Object)this.scheme, (Object)uri.scheme) && OpUtil.compareEQ((Object)this.userInfo, (Object)uri.userInfo) && OpUtil.compareEQ((Object)this.host, (Object)uri.host) && OpUtil.compareEQ((Object)this.port, (Object)uri.port))) {
            return this;
        }
        Sections sections = new Sections();
        sections.query = this.query;
        sections.queryStr = this.queryStr;
        sections.frag = this.frag;
        int n2 = Math.min(this.path.sz(), uri.path.sz());
        for (n = 0; n < n2 && this.path.get(n).equals(uri.path.get(n)); ++n) {
        }
        if (n == 0) {
            if (uri.path.isEmpty() && this.pathStr.startsWith("/")) {
                sections.path = this.path;
                sections.pathStr = this.pathStr.substring(1);
            } else {
                sections.path = this.path;
                sections.pathStr = this.pathStr;
            }
        } else if (n == this.path.sz() && n == uri.path.sz()) {
            sections.path = Uri.emptyPath();
            sections.pathStr = "";
        } else {
            sections.path = this.path.getRange(Range.makeInclusive(n, -1L));
            int n3 = uri.path.sz() - n;
            if (!uri.isDir()) {
                // empty if block
            }
            while (true) {
                int n4 = --n3;
                --n3;
                if (n4 <= 0) break;
                sections.path.insert(0L, (Object)"..");
            }
            sections.pathStr = Uri.toPathStr(false, sections.path, this.isDir());
        }
        return new Uri(sections);
    }

    public Uri relToAuth() {
        if (this.scheme == null && this.userInfo == null && this.host == null && this.port == null) {
            return this;
        }
        Sections sections = new Sections();
        sections.path = this.path;
        sections.pathStr = this.pathStr;
        sections.query = this.query;
        sections.queryStr = this.queryStr;
        sections.frag = this.frag;
        return new Uri(sections);
    }

    public Uri plus(Uri uri) {
        if (uri.scheme != null) {
            return uri;
        }
        if (uri.host != null && this.scheme == null) {
            return uri;
        }
        if (uri.isPathAbs() && this.host == null) {
            return uri;
        }
        Uri uri2 = this;
        Sections sections = new Sections();
        if (uri.host != null) {
            sections.setAuth(uri);
            sections.setPath(uri);
            sections.setQuery(uri);
        } else {
            if (uri.pathStr == null || uri.pathStr.equals("")) {
                sections.setPath(uri2);
                if (uri.queryStr != null) {
                    sections.setQuery(uri);
                } else {
                    sections.setQuery(uri2);
                }
            } else {
                if (uri.pathStr.startsWith("/")) {
                    sections.setPath(uri);
                } else {
                    Uri.merge(sections, uri2, uri);
                }
                sections.setQuery(uri);
            }
            sections.setAuth(uri2);
        }
        sections.scheme = uri2.scheme;
        sections.frag = uri.frag;
        sections.normalize();
        return new Uri(sections);
    }

    static void merge(Sections sections, Uri uri, Uri uri2) {
        List list;
        boolean bl = uri.isPathAbs();
        boolean bl2 = uri.isDir();
        boolean bl3 = uri2.isDir();
        List list2 = uri2.path;
        boolean bl4 = false;
        if (uri.path.sz() == 0) {
            list = uri2.path;
        } else {
            list = uri.path.rw();
            if (!bl2) {
                list.pop();
            }
            for (int i = 0; i < list2.sz(); ++i) {
                String string = (String)list2.get(i);
                if (string.equals(".")) {
                    bl4 = true;
                    continue;
                }
                if (string.equals("..")) {
                    if (!list.isEmpty()) {
                        list.pop();
                        bl4 = true;
                        continue;
                    }
                    if (bl) continue;
                }
                list.add(string);
                bl4 = false;
            }
        }
        sections.path = list;
        sections.pathStr = Uri.toPathStr(bl, list, bl3 || bl4);
    }

    static String toPathStr(boolean bl, List list, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append('/');
        }
        for (int i = 0; i < list.sz(); ++i) {
            if (i > 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append(list.get(i));
        }
        if (bl2 && (stringBuilder.length() <= 0 || stringBuilder.charAt(stringBuilder.length() - 1) != '/')) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public Uri plusName(String string) {
        return this.plusName(string, false);
    }

    public Uri plusName(String string, boolean bl) {
        int n = this.path.sz();
        boolean bl2 = this.isDir();
        int n2 = bl2 ? n + 1 : n;
        Object[] objectArray = (String[])this.path.toArray(new String[n2]);
        objectArray[n2 - 1] = string;
        Sections sections = new Sections();
        sections.scheme = this.scheme;
        sections.userInfo = this.userInfo;
        sections.host = this.host;
        sections.port = this.port;
        sections.query = Uri.emptyQuery();
        sections.queryStr = null;
        sections.frag = null;
        sections.path = new List(Sys.StrType, objectArray);
        sections.pathStr = Uri.toPathStr(this.isPathAbs(), sections.path, bl);
        return new Uri(sections);
    }

    public Uri plusSlash() {
        if (this.isDir()) {
            return this;
        }
        Sections sections = new Sections();
        sections.scheme = this.scheme;
        sections.userInfo = this.userInfo;
        sections.host = this.host;
        sections.port = this.port;
        sections.query = this.query;
        sections.queryStr = this.queryStr;
        sections.frag = this.frag;
        sections.path = this.path;
        sections.pathStr = this.pathStr + "/";
        return new Uri(sections);
    }

    public Uri plusQuery(Map map) {
        Object object;
        if (map == null || map.isEmpty()) {
            return this;
        }
        Map map2 = this.query.dup().setAll(map);
        StringBuilder stringBuilder = new StringBuilder(256);
        Iterator iterator = map2.pairsIterator();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            object = (Map.Entry)iterator.next();
            String string = (String)object.getKey();
            String string2 = (String)object.getValue();
            Uri.appendQueryStr(stringBuilder, string);
            stringBuilder.append('=');
            Uri.appendQueryStr(stringBuilder, string2);
        }
        object = new Sections();
        ((Sections)object).scheme = this.scheme;
        ((Sections)object).userInfo = this.userInfo;
        ((Sections)object).host = this.host;
        ((Sections)object).port = this.port;
        ((Sections)object).frag = this.frag;
        ((Sections)object).pathStr = this.pathStr;
        ((Sections)object).path = this.path;
        ((Sections)object).query = map2.ro();
        ((Sections)object).queryStr = stringBuilder.toString();
        return new Uri((Sections)object);
    }

    static void appendQueryStr(StringBuilder stringBuilder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < delimEscMap.length && (delimEscMap[c] & 0x10) != 0) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
    }

    public File toFile() {
        return File.make(this);
    }

    public Object get() {
        return this.get(null, true);
    }

    public Object get(Object object) {
        return this.get(object, true);
    }

    public Object get(Object object, boolean bl) {
        FanObj fanObj;
        Uri uri = this;
        if (this.scheme == null) {
            if (object == null) {
                throw UnresolvedErr.make("Relative uri with no base: " + this);
            }
            fanObj = null;
            try {
                fanObj = (Uri)Uri.trap(object, "uri", null);
                if (fanObj == null) {
                    throw UnresolvedErr.make("Base object's uri is null: " + this);
                }
            }
            catch (Throwable throwable) {
                throw UnresolvedErr.make("Cannot access base '" + FanObj.typeof(object) + ".uri' to normalize: " + this, throwable);
            }
            if (((Uri)fanObj).scheme == null) {
                throw UnresolvedErr.make("Base object's uri is not absolute: " + fanObj);
            }
            uri = ((Uri)fanObj).plus(this);
        }
        fanObj = UriScheme.find(uri.scheme);
        try {
            return ((UriScheme)fanObj).get(uri, object);
        }
        catch (UnresolvedErr unresolvedErr) {
            if (bl) {
                throw unresolvedErr;
            }
            return null;
        }
    }

    public String toCode() {
        StringBuilder stringBuilder = new StringBuilder(this.str.length() + 4);
        stringBuilder.append('`');
        int n = this.str.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = this.str.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append('\\').append('f');
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append('\\').append('t');
                    continue block8;
                }
                case '`': {
                    stringBuilder.append('\\').append('`');
                    continue block8;
                }
                case '$': {
                    stringBuilder.append('\\').append('$');
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.append('`').toString();
    }

    public static boolean isName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (string.charAt(0) == '.' && n <= 2) {
            if (n == 1) {
                return false;
            }
            if (string.charAt(1) == '.') {
                return false;
            }
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080' && nameMap[c]) continue;
            return false;
        }
        return true;
    }

    public static void checkName(String string) {
        if (!Uri.isName(string)) {
            throw NameErr.make(string);
        }
    }

    static boolean isUpper(int n) {
        return 65 <= n && n <= 90;
    }

    static int hexNibble(int n) {
        if ((charMap[n] & 0x80) == 0) {
            throw Uri.err("Invalid percent encoded hex: '" + (char)n);
        }
        if (n <= 57) {
            return n - 48;
        }
        if (n <= 90) {
            return n - 65 + 10;
        }
        return n - 97 + 10;
    }

    static RuntimeException err(String string) {
        return ParseErr.make(string);
    }

    static String toSection(int n) {
        switch (n) {
            case 1: {
                return "scheme";
            }
            case 2: {
                return "userInfo";
            }
            case 4: {
                return "host";
            }
            case 8: {
                return "path";
            }
            case 16: {
                return "query";
            }
            case 32: {
                return "frag";
            }
        }
        return "uri";
    }

    static boolean isScheme(int n) {
        return n < 128 ? (charMap[n] & 1) != 0 : false;
    }

    static List emptyPath() {
        return Sys.StrType.emptyList();
    }

    static Map emptyQuery() {
        return Sys.emptyStrStrMap;
    }

    static {
        int n;
        charMap = new byte[128];
        nameMap = new boolean[128];
        delimEscMap = new byte[128];
        int n2 = 63;
        for (n = 97; n <= 122; ++n) {
            Uri.charMap[n] = n2;
            Uri.nameMap[n] = true;
        }
        for (n = 65; n <= 90; ++n) {
            Uri.charMap[n] = n2;
            Uri.nameMap[n] = true;
        }
        for (n = 48; n <= 57; ++n) {
            Uri.charMap[n] = n2;
            Uri.nameMap[n] = true;
        }
        Uri.charMap[45] = n2;
        Uri.nameMap[45] = true;
        Uri.charMap[46] = n2;
        Uri.nameMap[46] = true;
        Uri.charMap[95] = n2;
        Uri.nameMap[95] = true;
        Uri.charMap[126] = n2;
        Uri.nameMap[126] = true;
        n = 48;
        while (n <= 57) {
            int n3 = n++;
            charMap[n3] = (byte)(charMap[n3] | 0xC0);
        }
        n = 97;
        while (n <= 102) {
            int n4 = n++;
            charMap[n4] = (byte)(charMap[n4] | 0x80);
        }
        n = 65;
        while (n <= 70) {
            int n5 = n++;
            charMap[n5] = (byte)(charMap[n5] | 0x80);
        }
        Uri.charMap[33] = 62;
        Uri.charMap[36] = 62;
        Uri.charMap[38] = 62;
        Uri.charMap[39] = 62;
        Uri.charMap[40] = 62;
        Uri.charMap[41] = 62;
        Uri.charMap[42] = 62;
        Uri.charMap[43] = 47;
        Uri.charMap[44] = 62;
        Uri.charMap[59] = 62;
        Uri.charMap[61] = 62;
        Uri.charMap[58] = 58;
        Uri.charMap[47] = 56;
        Uri.charMap[63] = 48;
        Uri.charMap[35] = 0;
        Uri.charMap[91] = 0;
        Uri.charMap[93] = 0;
        Uri.charMap[64] = 56;
        Uri.delimEscMap[58] = 8;
        Uri.delimEscMap[47] = 8;
        Uri.delimEscMap[63] = 8;
        Uri.delimEscMap[35] = 24;
        Uri.delimEscMap[38] = 16;
        Uri.delimEscMap[59] = 16;
        Uri.delimEscMap[61] = 16;
        Uri.delimEscMap[92] = 63;
        parentRange = Range.make(0L, -2L, false);
        defVal = Uri.fromStr("");
    }

    static class Encoder {
        Uri uri;
        boolean encoding;
        StringBuilder buf;

        Encoder(Uri uri, boolean bl) {
            this.uri = uri;
            this.encoding = bl;
            this.buf = new StringBuilder();
        }

        String encode() {
            Uri uri = this.uri;
            StringBuilder stringBuilder = this.buf;
            if (uri.scheme != null) {
                stringBuilder.append(uri.scheme).append(':');
            }
            if (uri.userInfo != null || uri.host != null || uri.port != null) {
                stringBuilder.append('/').append('/');
                if (uri.userInfo != null) {
                    this.encode(uri.userInfo, 2).append('@');
                }
                if (uri.host != null) {
                    this.encode(uri.host, 4);
                }
                if (uri.port != null) {
                    stringBuilder.append(':').append(uri.port);
                }
            }
            if (uri.pathStr != null) {
                this.encode(uri.pathStr, 8);
            }
            if (uri.queryStr != null) {
                stringBuilder.append('?');
                this.encode(uri.queryStr, 16);
            }
            if (uri.frag != null) {
                stringBuilder.append('#');
                this.encode(uri.frag, 32);
            }
            return stringBuilder.toString();
        }

        StringBuilder encode(String string, int n) {
            if (!this.encoding) {
                return this.buf.append(string);
            }
            StringBuilder stringBuilder = this.buf;
            int n2 = string.length();
            char c = '\u0000';
            for (int i = 0; i < n2; ++i) {
                char c2 = c;
                c = string.charAt(i);
                if (c < '\u0080' && (charMap[c] & n) != 0 && c2 != '\\') {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '\\' && c2 != '\\') continue;
                if (c == ' ' && n == 16) {
                    stringBuilder.append('+');
                } else {
                    Uri.percentEncodeChar(stringBuilder, c);
                }
                if (c != '\\') continue;
                c = '\u0000';
            }
            return stringBuilder;
        }
    }

    static class Decoder
    extends Sections {
        boolean decoding;
        int dpos;
        boolean nextCharWasEscaped;

        Decoder(String string, boolean bl) {
            this.str = string;
            this.decoding = bl;
        }

        Decoder decode() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            String string = this.str;
            int n6 = string.length();
            int n7 = 0;
            boolean bl = false;
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = string.charAt(n5);
                if (Uri.isScheme(n4)) {
                    bl |= Uri.isUpper(n4);
                    continue;
                }
                if (n4 != 58) break;
                n7 = n5 + 1;
                String string2 = string.substring(0, n5);
                if (bl) {
                    string2 = FanStr.lower(string2);
                }
                this.scheme = string2;
                break;
            }
            if (n7 + 1 < n6 && string.charAt(n7) == '/' && string.charAt(n7 + 1) == '/') {
                n5 = n7 + 2;
                n4 = n6;
                int n8 = -1;
                n3 = -1;
                for (n2 = n5; n2 < n6; ++n2) {
                    n = string.charAt(n2);
                    if (n == 47 || n == 63 || n == 35) {
                        n4 = n2;
                        break;
                    }
                    if (n == 64 && n8 < 0) {
                        n8 = n2;
                        n3 = -1;
                        continue;
                    }
                    if (n == 58) {
                        n3 = n2;
                        continue;
                    }
                    if (n != 93) continue;
                    n3 = -1;
                }
                n2 = n5;
                n = n4;
                if (n8 > 0) {
                    this.userInfo = this.substring(n5, n8, 2);
                    n2 = n8 + 1;
                }
                if (n3 > 0) {
                    this.port = Integer.parseInt(string.substring(n3 + 1, n4));
                    n = n3;
                }
                this.host = this.substring(n2, n, 4);
                n7 = n4;
            }
            n5 = n7;
            n4 = n6;
            int n9 = 1;
            n3 = 0;
            for (n2 = n5; n2 < n6; ++n2) {
                n = string.charAt(n2);
                if (n3 != 92) {
                    if (n == 63 || n == 35) {
                        n4 = n2;
                        break;
                    }
                    if (n2 != n5 && n == 47) {
                        ++n9;
                    }
                    n3 = n;
                    continue;
                }
                n3 = n != 92 ? n : 0;
            }
            this.pathStr = this.substring(n5, n4, 8);
            this.path = this.pathSegments(this.pathStr, n9);
            n7 = n4;
            if (n7 < n6 && string.charAt(n7) == '?') {
                n2 = n7 + 1;
                n = n6;
                n3 = 0;
                for (int i = n2; i < n6; ++i) {
                    char c = string.charAt(i);
                    if (n3 != 92) {
                        if (c == '#') {
                            n = i;
                            break;
                        }
                        n3 = c;
                        continue;
                    }
                    n3 = c != '\\' ? c : (char)'\u0000';
                }
                this.queryStr = this.substring(n2, n, 16);
                this.query = this.parseQuery(this.queryStr);
                n7 = n;
            }
            if (n7 < n6 && string.charAt(n7) == '#') {
                this.frag = this.substring(n7 + 1, n6, 32);
            }
            this.normalize();
            this.str = null;
            return this;
        }

        private List pathSegments(String string, int n) {
            int n2 = string.length();
            if (n2 == 0 || n2 == 1 && string.charAt(0) == '/') {
                return Uri.emptyPath();
            }
            if (n2 > 1 && string.charAt(n2 - 1) == '/') {
                --n;
                --n2;
            }
            Object[] objectArray = new String[n];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (n5 != 92) {
                    if (c == '/') {
                        if (i > 0) {
                            objectArray[n3++] = string.substring(n4, i);
                        }
                        n4 = i + 1;
                    }
                    n5 = c;
                    continue;
                }
                n5 = c != '\\' ? c : (char)'\u0000';
            }
            if (n4 < n2) {
                objectArray[n3++] = string.substring(n4, string.length());
            }
            return new List(Sys.StrType, objectArray);
        }

        Map decodeQuery() {
            return this.parseQuery(this.substring(0, this.str.length(), 16));
        }

        private Map parseQuery(String string) {
            if (string == null) {
                return null;
            }
            Map map = new Map(Sys.StrType, Sys.StrType);
            try {
                int n = 0;
                int n2 = 0;
                int n3 = string.length();
                int n4 = 0;
                boolean bl = false;
                for (int i = 0; i < n3; ++i) {
                    char c = string.charAt(i);
                    if (n4 != 92) {
                        if (c == '=') {
                            n2 = i;
                        }
                        if (c != '&' && c != ';') {
                            n4 = c;
                            continue;
                        }
                    } else {
                        bl = true;
                        n4 = c != '\\' ? c : (char)'\u0000';
                        continue;
                    }
                    if (n < i) {
                        this.addQueryParam(map, string, n, n2, i, bl);
                        bl = false;
                    }
                    n = n2 = i + 1;
                }
                if (n < n3) {
                    this.addQueryParam(map, string, n, n2, n3, bl);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return map;
        }

        private void addQueryParam(Map map, String string, int n, int n2, int n3, boolean bl) {
            String string2;
            String string3;
            if (n == n2 && string.charAt(n) != '=') {
                string3 = this.toQueryStr(string, n, n3, bl);
                string2 = "true";
            } else {
                string3 = this.toQueryStr(string, n, n2, bl);
                string2 = this.toQueryStr(string, n2 + 1, n3, bl);
            }
            String string4 = (String)map.get(string3);
            if (string4 != null) {
                string2 = string4 + "," + string2;
            }
            map.set(string3, string2);
        }

        private String toQueryStr(String string, int n, int n2, boolean bl) {
            if (!bl) {
                return string.substring(n, n2);
            }
            StringBuilder stringBuilder = new StringBuilder(n2 - n);
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                if (c != '\\') {
                    stringBuilder.append(c);
                    n3 = c;
                    continue;
                }
                if (n3 == 92) {
                    stringBuilder.append(c);
                    n3 = 0;
                    continue;
                }
                n3 = c;
            }
            return stringBuilder.toString();
        }

        private String substring(int n, int n2, int n3) {
            if (!this.decoding) {
                return this.str.substring(n, n2);
            }
            StringBuilder stringBuilder = new StringBuilder(n2 - n);
            this.dpos = n;
            while (this.dpos < n2) {
                int n4 = this.nextChar(n3);
                if (this.nextCharWasEscaped && n4 < delimEscMap.length && (delimEscMap[n4] & n3) != 0) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append((char)n4);
            }
            return stringBuilder.toString();
        }

        private int nextChar(int n) {
            int n2 = this.nextOctet(n);
            if (n2 < 0) {
                return -1;
            }
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return n2;
                }
                case 12: 
                case 13: {
                    int n3 = this.nextOctet(n);
                    if ((n3 & 0xC0) != 128) {
                        throw Uri.err("Invalid UTF-8 encoding");
                    }
                    return (n2 & 0x1F) << 6 | n3 & 0x3F;
                }
                case 14: {
                    int n4 = this.nextOctet(n);
                    int n5 = this.nextOctet(n);
                    if ((n4 & 0xC0) != 128 || (n5 & 0xC0) != 128) {
                        throw Uri.err("Invalid UTF-8 encoding");
                    }
                    return (n2 & 0xF) << 12 | (n4 & 0x3F) << 6 | (n5 & 0x3F) << 0;
                }
            }
            throw Uri.err("Invalid UTF-8 encoding");
        }

        private int nextOctet(int n) {
            char c;
            if ((c = this.str.charAt(this.dpos++)) == '%') {
                this.nextCharWasEscaped = true;
                return Uri.hexNibble(this.str.charAt(this.dpos++)) << 4 | Uri.hexNibble(this.str.charAt(this.dpos++));
            }
            this.nextCharWasEscaped = false;
            if (c == '+' && n == 16) {
                return 32;
            }
            if (c >= charMap.length || (charMap[c] & n) == 0) {
                throw Uri.err("Invalid char in " + Uri.toSection(n) + " at index " + (this.dpos - 1));
            }
            return c;
        }
    }

    static class Sections {
        String scheme;
        String host;
        String userInfo;
        Long port;
        String pathStr;
        List path;
        String queryStr;
        Map query;
        String frag;
        String str;

        Sections() {
        }

        void setAuth(Uri uri) {
            this.userInfo = uri.userInfo;
            this.host = uri.host;
            this.port = uri.port;
        }

        void setPath(Uri uri) {
            this.pathStr = uri.pathStr;
            this.path = uri.path;
        }

        void setQuery(Uri uri) {
            this.queryStr = uri.queryStr;
            this.query = uri.query;
        }

        void setFrag(Uri uri) {
            this.frag = uri.frag;
        }

        void normalize() {
            this.normalizeHttp();
            this.normalizePath();
            this.normalizeQuery();
        }

        private void normalizeHttp() {
            if (this.scheme == null || !this.scheme.equals("http")) {
                return;
            }
            if (this.port != null && this.port == 80L) {
                this.port = null;
            }
            if (this.pathStr == null || this.pathStr.length() == 0) {
                this.pathStr = "/";
                if (this.path == null) {
                    this.path = Uri.emptyPath();
                }
            }
        }

        private void normalizePath() {
            if (this.path == null) {
                return;
            }
            boolean bl = this.pathStr.startsWith("/");
            boolean bl2 = this.pathStr.endsWith("/");
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < this.path.sz(); ++i) {
                String string = (String)this.path.get(i);
                if (string.equals(".") && (this.path.sz() > 1 || this.host != null)) {
                    this.path.removeAt(i);
                    bl4 = true;
                    bl3 = true;
                    --i;
                    continue;
                }
                if (string.equals("..") && i > 0 && !this.path.get(i - 1).toString().equals("..")) {
                    this.path.removeAt(i);
                    this.path.removeAt(i - 1);
                    bl4 = true;
                    i -= 2;
                    bl3 = true;
                    continue;
                }
                bl3 = false;
            }
            if (bl4) {
                if (bl3) {
                    bl2 = true;
                }
                if (this.path.sz() == 0 || this.path.last().toString().equals("..")) {
                    bl2 = false;
                }
                this.pathStr = Uri.toPathStr(bl, this.path, bl2);
            }
        }

        private void normalizeQuery() {
            if (this.query == null) {
                this.query = Uri.emptyQuery();
            }
        }
    }
}

