/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanObj;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.OutStream;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class Charset
extends FanObj {
    static Charset utf8;
    static Charset utf16BE;
    static Charset utf16LE;
    static Charset iso8859_1;
    final java.nio.charset.Charset charset;
    final String name;

    public static Charset fromStr(String string) {
        return Charset.fromStr(string, true);
    }

    public static Charset fromStr(String string, boolean bl) {
        try {
            java.nio.charset.Charset charset = java.nio.charset.Charset.forName(string);
            String string2 = charset.name().toUpperCase();
            if (string2.equals("UTF-8")) {
                return Charset.utf8();
            }
            if (string2.equals("UTF-16BE")) {
                return Charset.utf16BE();
            }
            if (string2.equals("UTF-16LE")) {
                return Charset.utf16LE();
            }
            if (string2.equals("ISO-8859-1")) {
                return Charset.iso8859_1();
            }
            return new Charset(charset);
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Charset", string, exception.toString());
        }
    }

    private Charset(java.nio.charset.Charset charset) {
        this.charset = charset;
        this.name = charset.name();
    }

    public static Charset defVal() {
        return Charset.utf8();
    }

    public static Charset utf8() {
        if (utf8 == null) {
            utf8 = new Charset(java.nio.charset.Charset.forName("UTF-8")){
                final Encoder encoder = new Utf8Encoder();
                final Decoder decoder = new Utf8Decoder();

                public Encoder newEncoder() {
                    return this.encoder;
                }

                public Decoder newDecoder() {
                    return this.decoder;
                }
            };
        }
        return utf8;
    }

    public static Charset utf16BE() {
        if (utf16BE == null) {
            utf16BE = new Charset(java.nio.charset.Charset.forName("UTF-16BE")){
                final Encoder encoder = new Utf16BEEncoder();
                final Decoder decoder = new Utf16BEDecoder();

                public Encoder newEncoder() {
                    return this.encoder;
                }

                public Decoder newDecoder() {
                    return this.decoder;
                }
            };
        }
        return utf16BE;
    }

    public static Charset utf16LE() {
        if (utf16LE == null) {
            utf16LE = new Charset(java.nio.charset.Charset.forName("UTF-16LE")){
                final Encoder encoder = new Utf16LEEncoder();
                final Decoder decoder = new Utf16LEDecoder();

                public Encoder newEncoder() {
                    return this.encoder;
                }

                public Decoder newDecoder() {
                    return this.decoder;
                }
            };
        }
        return utf16LE;
    }

    public static Charset iso8859_1() {
        if (iso8859_1 == null) {
            iso8859_1 = new Charset(java.nio.charset.Charset.forName("ISO-8859-1")){
                final Encoder encoder = new Iso8859Encoder();
                final Decoder decoder = new Iso8859Decoder();

                public Encoder newEncoder() {
                    return this.encoder;
                }

                public Decoder newDecoder() {
                    return this.decoder;
                }
            };
        }
        return iso8859_1;
    }

    public Type typeof() {
        return Sys.CharsetType;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.charset.hashCode();
    }

    public long hash() {
        return this.charset.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Charset) {
            return ((Charset)object).charset.equals(this.charset);
        }
        return false;
    }

    public String toStr() {
        return this.name;
    }

    public Encoder newEncoder() {
        return new NioEncoder(this);
    }

    public Decoder newDecoder() {
        return new NioDecoder(this);
    }

    static class NioDecoder
    extends Decoder {
        Charset charset;
        CharsetDecoder decoder;
        CharBuffer cbuf = CharBuffer.allocate(16);
        ByteBuffer bbuf = ByteBuffer.allocate(16);

        NioDecoder(Charset charset) {
            this.charset = charset;
            this.decoder = charset.charset.newDecoder();
        }

        public int decode(InStream inStream) {
            this.decoder.reset();
            this.bbuf.clear();
            do {
                int n;
                if ((n = inStream.r()) < 0) {
                    return -1;
                }
                this.cbuf.clear();
                this.bbuf.put((byte)n);
                this.bbuf.flip();
                CoderResult coderResult = this.decoder.decode(this.bbuf, this.cbuf, false);
                if (coderResult.isError()) {
                    throw IOErr.make("Invalid " + this.charset.name + " encoding");
                }
                this.bbuf.compact();
                this.cbuf.flip();
            } while (!this.cbuf.hasRemaining());
            return this.cbuf.get();
        }
    }

    public static abstract class Decoder {
        public abstract int decode(InStream var1);
    }

    static class NioEncoder
    extends Encoder {
        Charset charset;
        CharsetEncoder encoder;
        CharBuffer cbuf = CharBuffer.allocate(1);
        ByteBuffer bbuf = ByteBuffer.allocate(16);

        NioEncoder(Charset charset) {
            this.charset = charset;
            this.encoder = charset.charset.newEncoder();
        }

        public void encode(char c, OutStream outStream) {
            this.cbuf.clear();
            this.cbuf.put(c);
            this.cbuf.flip();
            this.bbuf.clear();
            this.encoder.reset();
            CoderResult coderResult = this.encoder.encode(this.cbuf, this.bbuf, true);
            if (coderResult.isError()) {
                throw IOErr.make("Invalid " + this.charset.name + " encoding");
            }
            coderResult = this.encoder.flush(this.bbuf);
            if (coderResult.isError()) {
                throw IOErr.make("Invalid " + this.charset.name + " encoding");
            }
            this.bbuf.flip();
            while (this.bbuf.hasRemaining()) {
                outStream.w(this.bbuf.get());
            }
        }

        public void encode(char c, InStream inStream) {
            this.cbuf.clear();
            this.cbuf.put(c);
            this.cbuf.flip();
            this.bbuf.clear();
            this.encoder.reset();
            CoderResult coderResult = this.encoder.encode(this.cbuf, this.bbuf, true);
            if (coderResult.isError()) {
                throw IOErr.make("Invalid " + this.charset.name + " encoding");
            }
            coderResult = this.encoder.flush(this.bbuf);
            if (coderResult.isError()) {
                throw IOErr.make("Invalid " + this.charset.name + " encoding");
            }
            this.bbuf.flip();
            while (this.bbuf.hasRemaining()) {
                inStream.unread(this.bbuf.get());
            }
        }
    }

    public static abstract class Encoder {
        public abstract void encode(char var1, OutStream var2);

        public abstract void encode(char var1, InStream var2);
    }

    static class Iso8859Decoder
    extends Decoder {
        Iso8859Decoder() {
        }

        public int decode(InStream inStream) {
            return inStream.r();
        }
    }

    static class Iso8859Encoder
    extends Encoder {
        Iso8859Encoder() {
        }

        public void encode(char c, OutStream outStream) {
            if (c > '\u00ff') {
                throw IOErr.make("Invalid ISO-8859-1 char");
            }
            outStream.w(c >>> 0 & 0xFF);
        }

        public void encode(char c, InStream inStream) {
            inStream.unread(c >>> 0 & 0xFF);
        }
    }

    static class Utf16LEDecoder
    extends Decoder {
        Utf16LEDecoder() {
        }

        public int decode(InStream inStream) {
            int n;
            int n2 = inStream.r();
            if ((n2 | (n = inStream.r())) < 0) {
                return -1;
            }
            return n2 | n << 8;
        }
    }

    static class Utf16LEEncoder
    extends Encoder {
        Utf16LEEncoder() {
        }

        public void encode(char c, OutStream outStream) {
            outStream.w(c >>> 0 & 0xFF).w(c >>> 8 & 0xFF);
        }

        public void encode(char c, InStream inStream) {
            inStream.unread(c >>> 8 & 0xFF).unread(c >>> 0 & 0xFF);
        }
    }

    static class Utf16BEDecoder
    extends Decoder {
        Utf16BEDecoder() {
        }

        public int decode(InStream inStream) {
            int n;
            int n2 = inStream.r();
            if ((n2 | (n = inStream.r())) < 0) {
                return -1;
            }
            return n2 << 8 | n;
        }
    }

    static class Utf16BEEncoder
    extends Encoder {
        Utf16BEEncoder() {
        }

        public void encode(char c, OutStream outStream) {
            outStream.w(c >>> 8 & 0xFF).w(c >>> 0 & 0xFF);
        }

        public void encode(char c, InStream inStream) {
            inStream.unread(c >>> 0 & 0xFF).unread(c >>> 8 & 0xFF);
        }
    }

    static class Utf8Decoder
    extends Decoder {
        Utf8Decoder() {
        }

        public int decode(InStream inStream) {
            int n = inStream.r();
            if (n < 0) {
                return -1;
            }
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return n;
                }
                case 12: 
                case 13: {
                    int n2 = inStream.r();
                    if ((n2 & 0xC0) != 128) {
                        throw IOErr.make("Invalid UTF-8 encoding");
                    }
                    return (n & 0x1F) << 6 | n2 & 0x3F;
                }
                case 14: {
                    int n3 = inStream.r();
                    int n4 = inStream.r();
                    if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                        throw IOErr.make("Invalid UTF-8 encoding");
                    }
                    return (n & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0;
                }
            }
            throw IOErr.make("Invalid UTF-8 encoding");
        }
    }

    static class Utf8Encoder
    extends Encoder {
        Utf8Encoder() {
        }

        public void encode(char c, OutStream outStream) {
            if (c <= '\u007f') {
                outStream.w(c);
            } else if (c > '\u07ff') {
                outStream.w(0xE0 | c >> 12 & 0xF).w(0x80 | c >> 6 & 0x3F).w(0x80 | c >> 0 & 0x3F);
            } else {
                outStream.w(0xC0 | c >> 6 & 0x1F).w(0x80 | c >> 0 & 0x3F);
            }
        }

        public void encode(char c, InStream inStream) {
            if (c <= '\u007f') {
                inStream.unread(c);
            } else if (c > '\u07ff') {
                inStream.unread(0x80 | c >> 0 & 0x3F).unread(0x80 | c >> 6 & 0x3F).unread(0xE0 | c >> 12 & 0xF);
            } else {
                inStream.unread(0x80 | c >> 0 & 0x3F).unread(0xC0 | c >> 6 & 0x1F);
            }
        }
    }
}

