//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;

/** JcfClassOutput extends the basic data output functionality in DataOutput, 
 *  while adding methods to facilitate writing class file specific data types. 
 */
public interface JcfClassOutput extends DataOutput
{
  /** Write the index of a constant pool entry.
   * @param cpIndex The index of the entry. */
  void writeCPRef (int cpIndex) throws IOException;

  /** Write a short value (usually bit flags) that is not a magnitude. */
  void writeShortVerbatim (int value) throws IOException;

  /** Write a short value, where the maximum value that short can have
   * is less than or equal to maxValue. */
  void writeShortMax (int value, int maxValue) throws IOException;

  /** Write an int value (usually bit flags) that is not a magnitude. */
  void writeIntVerbatim (int value) throws IOException;
}
