/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

/**
 * Select items from a list or cancel.
 *
 * @version  $Id: ListCancelSelector.java,v 1.11 2003/05/01 16:44:21 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class ListCancelSelector extends ExitJDialog implements ActionListener 
{
    private static final int MAX_ELEMENTS = 20;
    protected JList _lst;
    private String _sValue = "";
    private JButton _btnOk;
    private JButton _btnCancel;
    protected JLabel[] _alblHeadline;
    protected boolean _bOK = false;

    public ListCancelSelector(String sMessage_, Vector vsList_) 
    {
        this(new Frame(), sMessage_, vsList_);
    }
    
    protected void _fillList(Vector vsItems_) 
    {
        ((DefaultListModel)_lst.getModel()).removeAllElements();
        _lst.clearSelection();
        for(Enumeration e = vsItems_.elements(); e.hasMoreElements(); ) 
        {
            ((DefaultListModel)_lst.getModel()).addElement
                   (e.nextElement().toString());
        }
        /*_lst.setSelectedIndex( 0 );*/
    }

    public ListCancelSelector(Frame frmParent_, String sMessage_,
                              Vector vsList_)
    {
        this( frmParent_, sMessage_, vsList_, false );
    }

    public ListCancelSelector( Frame frmParent_, 
                               String sMessage_,
                               Vector vsList_, 
                               boolean bMultiSelect_ )
    {
        super(frmParent_, "Select", true);
        
        Util.panicIf(vsList_ == null || vsList_.size() == 0);
        
        _bOK = false;

        getContentPane().setLayout( new BorderLayout() );

        // Messages
        Vector vMessages = Util.stringToLines(sMessage_);
        JPanel pnlMessages = new JPanel();
        AutoGridBagLayout agblMessages = new AutoGridBagLayout();
        pnlMessages.setLayout(agblMessages);
        _alblHeadline = new JLabel[vMessages.size()];
        for(int line = 0; line < vMessages.size(); line++) 
        {
            // Message
            String sLine = (String)vMessages.elementAt(line);
            JLabel lblLine = new JLabel(sLine);
            _alblHeadline[line] = lblLine;
            agblMessages.setExpandHorizontal();
            agblMessages.setAnchor(GridBagConstraints.WEST);
            pnlMessages.add(lblLine);
            agblMessages.endLine();
        }
        getContentPane().add(pnlMessages, "North");

        // List
        _lst = new JList( new DefaultListModel() );
        if ( bMultiSelect_ ) 
        {
            _lst.setSelectionMode( ListSelectionModel.
                                   MULTIPLE_INTERVAL_SELECTION );
        }
        else 
        {
            _lst.setSelectionMode( ListSelectionModel.
                                   SINGLE_SELECTION );
        }
        _fillList(vsList_);
        JScrollPane scpList = new JScrollPane( _lst );
        scpList.setBorder( SwingUtil.createCCLBorder() );
        getContentPane().add(scpList, "Center");

        // OK and Cancel buttons
        JPanel pnlButtons = new JPanel();
        AutoGridBagLayout agblButtons = new AutoGridBagLayout();
        pnlButtons.setLayout(agblButtons);
        _btnCancel = new JButton("Cancel");
        _btnOk = new JButton("OK");
        _btnOk.setPreferredSize( _btnCancel.getPreferredSize() );
        _btnOk.addActionListener(this);
        pnlButtons.add(_btnOk);

        agblButtons.setExpandHorizontal();
        pnlButtons.add(new JLabel(" "));
        agblButtons.setExpandNone();
        
        _btnCancel.addActionListener(this);
        pnlButtons.add(_btnCancel);
        
        getContentPane().add(pnlButtons, "South");

        pack();
        setSize(getPreferredSize());
        SwingUtil.centerComponent(this);
    }

    public boolean isOK() 
    {
        return _bOK;
    }

    /**
     * @return   null on cancel, selected item on ok, "" if
     *           nothing was selected but OK was pushed.
     */
    public String getValue() 
    {
        if (!_bOK) 
        {
            return((String)null);
        }

        if ( _sValue == null ) 
        {
            return "";
        }

        return _sValue;
    }

    /**
     * @return   Vector of size 0 if there is nothing
     *           selected.
     */ 
    public Vector getValues() 
    {
        Object[] aoSelection = _lst.getSelectedValues();
        Vector vRetVal = Util.objectsToVector( aoSelection );

        return vRetVal;
    }

    public void exit() 
    {
        try 
        {
            _sValue = (String)(_lst.getSelectedValue().toString());
        }
        catch ( Exception pException ) 
        {
            _sValue = null;
        }

        super.exit();
    }
    
    public void actionPerformed(ActionEvent pActionEvent_) 
    {
        Object oSource = pActionEvent_.getSource();
        if (oSource == _btnOk) 
        {
            _bOK = true;
        }
        try 
        {
            _sValue = (String)(_lst.getSelectedValue().toString());
        }
        catch ( Exception pException ) 
        {
            _sValue = null;
        }

        setVisible(false);
    }

    public static Vector input( Frame frmParent_, 
                                String sMessage_,
                                Vector vsList_,
                                boolean bMultiSelect_ )
    {
        ListCancelSelector pDialog = new ListCancelSelector
               ( frmParent_, sMessage_, vsList_, bMultiSelect_ );
        pDialog.setVisible( true );
        
        return pDialog.getValues();
    }
}
