/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

public final class ClassStack {
    private Class[] stack;
    private int pointer;

    public ClassStack(int n) {
        this.stack = new Class[n];
    }

    public void push(Class clazz) {
        if (this.pointer + 1 >= this.stack.length) {
            this.resizeStack(this.stack.length * 2);
        }
        this.stack[this.pointer++] = clazz;
    }

    public void popSilently() {
        --this.pointer;
    }

    public Class pop() {
        return this.stack[--this.pointer];
    }

    public Class peek() {
        return this.pointer == 0 ? null : this.stack[this.pointer - 1];
    }

    public int size() {
        return this.pointer;
    }

    public Class get(int n) {
        return this.stack[n];
    }

    private void resizeStack(int n) {
        Class[] classArray = new Class[n];
        System.arraycopy(this.stack, 0, classArray, 0, Math.min(this.stack.length, n));
        this.stack = classArray;
    }
}

