/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.Base64;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlWriter;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XmlRpcClient
implements XmlRpcHandler {
    protected URL url;
    private String auth;
    protected Stack pool = new Stack();
    protected int workers = 0;
    protected int asyncWorkers = 0;
    private CallData first;
    private CallData last;

    public XmlRpcClient(URL uRL) {
        this.url = uRL;
        if (XmlRpc.debug) {
            System.out.println("Created client to url space " + uRL);
        }
    }

    public XmlRpcClient(String string) throws MalformedURLException {
        this(new URL(string));
    }

    public XmlRpcClient(String string, int n) throws MalformedURLException {
        this(new URL("http://" + string + ':' + n + "/RPC2"));
    }

    public URL getURL() {
        return this.url;
    }

    public void setBasicAuthentication(String string, String string2) {
        this.auth = string == null || string2 == null ? null : new String(Base64.encode((string + ':' + string2).getBytes())).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String string, Vector vector) throws XmlRpcException, IOException {
        Worker worker = this.getWorker(false);
        try {
            Object object;
            Object object2 = object = worker.execute(string, vector);
            return object2;
        }
        finally {
            this.releaseWorker(worker, false);
        }
    }

    public void executeAsync(String string, Vector vector, AsyncCallback asyncCallback) {
        if (this.asyncWorkers >= 4) {
            this.enqueue(string, vector, asyncCallback);
            return;
        }
        Worker worker = null;
        try {
            worker = this.getWorker(true);
            worker.start(string, vector, asyncCallback);
        }
        catch (IOException iOException) {
            this.enqueue(string, vector, asyncCallback);
        }
    }

    synchronized Worker getWorker(boolean bl) throws IOException {
        try {
            Worker worker = (Worker)this.pool.pop();
            if (bl) {
                ++this.asyncWorkers;
            } else {
                ++this.workers;
            }
            return worker;
        }
        catch (EmptyStackException emptyStackException) {
            if (this.workers < XmlRpc.getMaxThreads()) {
                if (bl) {
                    ++this.asyncWorkers;
                } else {
                    ++this.workers;
                }
                return new Worker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    synchronized void releaseWorker(Worker worker, boolean bl) {
        worker.result = null;
        worker.call = null;
        if (this.pool.size() < 20 && !worker.fault) {
            this.pool.push(worker);
        }
        if (bl) {
            --this.asyncWorkers;
        } else {
            --this.workers;
        }
    }

    synchronized void enqueue(String string, Vector vector, AsyncCallback asyncCallback) {
        CallData callData = new CallData(string, vector, asyncCallback);
        if (this.last == null) {
            this.first = this.last = callData;
        } else {
            this.last.next = callData;
            this.last = callData;
        }
    }

    synchronized CallData dequeue() {
        if (this.first == null) {
            return null;
        }
        CallData callData = this.first;
        if (this.first == this.last) {
            this.last = null;
            this.first = null;
        } else {
            this.first = this.first.next;
        }
        return callData;
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            Vector<Object> vector = new Vector<Object>();
            for (int i = 2; i < stringArray.length; ++i) {
                try {
                    vector.addElement(new Integer(Integer.parseInt(stringArray[i])));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    vector.addElement(stringArray[i]);
                }
            }
            XmlRpcClientLite xmlRpcClientLite = new XmlRpcClientLite(string);
            try {
                System.out.println(xmlRpcClientLite.execute(string2, vector));
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Usage: java org.apache.xmlrpc.XmlRpcClient <url> <method> <arg> ....");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }

    class CallData {
        String method;
        Vector params;
        AsyncCallback callback;
        CallData next;

        public CallData(String string, Vector vector, AsyncCallback asyncCallback) {
            this.method = string;
            this.params = vector;
            this.callback = asyncCallback;
            this.next = null;
        }
    }

    class Worker
    extends XmlRpc
    implements Runnable {
        boolean fault;
        Object result = null;
        ByteArrayOutputStream buffer;
        CallData call;

        public void start(String string, Vector vector, AsyncCallback asyncCallback) {
            this.call = new CallData(string, vector, asyncCallback);
            Thread thread = new Thread(this);
            thread.start();
        }

        public void run() {
            while (this.call != null) {
                this.executeAsync(this.call.method, this.call.params, this.call.callback);
                this.call = XmlRpcClient.this.dequeue();
            }
            XmlRpcClient.this.releaseWorker(this, true);
        }

        void executeAsync(String string, Vector vector, AsyncCallback asyncCallback) {
            block5: {
                Object object = null;
                try {
                    object = this.execute(string, vector);
                    if (asyncCallback != null) {
                        asyncCallback.handleResult(object, XmlRpcClient.this.url, string);
                    }
                }
                catch (Exception exception) {
                    if (asyncCallback == null) break block5;
                    try {
                        asyncCallback.handleError(exception, XmlRpcClient.this.url, string);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }

        Object execute(String string, Vector vector) throws XmlRpcException, IOException {
            Object object;
            Object object2;
            Object object3;
            this.fault = false;
            long l = 0L;
            if (XmlRpc.debug) {
                System.out.println("Client calling procedure '" + string + "' with parameters " + vector);
                l = System.currentTimeMillis();
            }
            try {
                object3 = new ByteArrayOutputStream();
                if (this.buffer == null) {
                    this.buffer = new ByteArrayOutputStream();
                } else {
                    this.buffer.reset();
                }
                object2 = new XmlWriter((OutputStream)this.buffer, encoding);
                this.writeRequest((XmlWriter)object2, string, vector);
                ((OutputStreamWriter)object2).flush();
                object = this.buffer.toByteArray();
                URLConnection uRLConnection = XmlRpcClient.this.url.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.setDoOutput(true);
                uRLConnection.setUseCaches(false);
                uRLConnection.setAllowUserInteraction(false);
                uRLConnection.setRequestProperty("Content-Length", Integer.toString(((byte[])object).length));
                uRLConnection.setRequestProperty("Content-Type", "text/xml");
                if (XmlRpcClient.this.auth != null) {
                    uRLConnection.setRequestProperty("Authorization", "Basic " + XmlRpcClient.this.auth);
                }
                OutputStream outputStream = uRLConnection.getOutputStream();
                outputStream.write((byte[])object);
                outputStream.flush();
                outputStream.close();
                InputStream inputStream = uRLConnection.getInputStream();
                this.parse(inputStream);
            }
            catch (Exception exception) {
                if (XmlRpc.debug) {
                    exception.printStackTrace();
                }
                throw new IOException(exception.getMessage());
            }
            if (this.fault) {
                object3 = null;
                try {
                    object2 = (Hashtable)this.result;
                    object = (String)((Hashtable)object2).get("faultString");
                    int n = Integer.parseInt(((Hashtable)object2).get("faultCode").toString());
                    object3 = new XmlRpcException(n, ((String)object).trim());
                }
                catch (Exception exception) {
                    throw new XmlRpcException(0, "Invalid fault response");
                }
                throw object3;
            }
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - l) + " in request");
            }
            return this.result;
        }

        protected void objectParsed(Object object) {
            this.result = object;
        }

        void writeRequest(XmlWriter xmlWriter, String string, Vector vector) throws IOException, XmlRpcException {
            xmlWriter.startElement("methodCall");
            xmlWriter.startElement("methodName");
            xmlWriter.write(string);
            xmlWriter.endElement("methodName");
            xmlWriter.startElement("params");
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                xmlWriter.startElement("param");
                xmlWriter.writeObject(vector.elementAt(i));
                xmlWriter.endElement("param");
            }
            xmlWriter.endElement("params");
            xmlWriter.endElement("methodCall");
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            if ("fault".equals(string)) {
                this.fault = true;
            } else {
                super.startElement(string, attributeList);
            }
        }
    }
}

