//
//  AppController.h
//  BinaryClocken
//
//  Created by John Schilling on Thu Jan 15 2004.
//  Copyright (c) 2004 John Schilling. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "LEDView.h"

@interface AppController : NSObject {

        IBOutlet NSWindow       *_clockWindow;
        IBOutlet NSWindow       *_prefsWindow;
        
        IBOutlet LEDView        *_LED_H0_01;
        IBOutlet LEDView        *_LED_H0_02;
        IBOutlet LEDView        *_LED_H1_01;
        IBOutlet LEDView        *_LED_H1_02;
        IBOutlet LEDView        *_LED_H1_03;
        IBOutlet LEDView        *_LED_H1_04;
        IBOutlet LEDView        *_LED_M0_01;
        IBOutlet LEDView        *_LED_M0_02;
        IBOutlet LEDView        *_LED_M0_03;
        IBOutlet LEDView        *_LED_M1_01;
        IBOutlet LEDView        *_LED_M1_02;
        IBOutlet LEDView        *_LED_M1_03;
        IBOutlet LEDView        *_LED_M1_04;
        IBOutlet LEDView        *_LED_S0_01;
        IBOutlet LEDView        *_LED_S0_02;
        IBOutlet LEDView        *_LED_S0_03;
        IBOutlet LEDView        *_LED_S1_01;
        IBOutlet LEDView        *_LED_S1_02;
        IBOutlet LEDView        *_LED_S1_03;
        IBOutlet LEDView        *_LED_S1_04;
        
        IBOutlet NSPopUpButton  *_PFColorMenu;
        IBOutlet NSMatrix       *_PFStyleMatrix;
        IBOutlet NSMatrix       *_PFLevelMatrix;
        IBOutlet NSButton       *_PFWindowShadowedButton;
        IBOutlet NSButton       *_PFNeverHideButton;
        IBOutlet NSButton       *_PFDockIconShitButton;
        
        IBOutlet NSMenu         *_clockMenu;
        IBOutlet NSMenuItem     *_24hourMenuItem;
        
        IBOutlet NSMenuItem     *_CM_24hourMenuItem;
        
        IBOutlet NSMenuItem     *_CM_WindowColor1MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor2MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor3MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor4MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor5MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor6MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor7MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor8MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor9MenuItem;
        IBOutlet NSMenuItem     *_CM_WindowColor10MenuItem;
        
        IBOutlet NSMenuItem     *_CM_WindowLevelNormalMenuItem;
        IBOutlet NSMenuItem     *_CM_WindowLevelFloatingMenuItem;
        IBOutlet NSMenuItem     *_CM_WindowLevelDesktopMenuItem;
        
        IBOutlet NSMenuItem     *_CM_WindowStyleWoodMenuItem;
        IBOutlet NSMenuItem     *_CM_WindowStyleMetalMenuItem;
        IBOutlet NSMenuItem     *_CM_WindowStyleBlackMenuItem;
        IBOutlet NSMenuItem     *_CM_WindowStyleClearMenuItem;
        
        IBOutlet NSMenuItem     *_CM_WindowShadowedMenuItem;
        IBOutlet NSMenuItem     *_CM_NeverHideMenuItem;
        IBOutlet NSMenuItem     *_CM_DoDockIconShit;
        
        NSTimer                 *_clockenTimer;
        
        int                     _LED_H0_num;
        int                     _LED_H1_num;
        int                     _LED_M0_num;
        int                     _LED_M1_num;
        int                     _LED_S0_num;
        int                     _LED_S1_num;
        
        int                     _LEDcolor;
        BOOL                    _twentyFourHour;
        int                     _windowLevel;
        int                     _windowStyle;
        BOOL                    _windowShadowed;
        BOOL                    _neverHide;
        BOOL                    _doDockIconShit;
        
        NSUserDefaults          *_pref_handler;
        BOOL                    _prefs_saved;
        
        NSTimer                 *_fadeTimer;
        BOOL                    _fadeInProgress;
}

- (void)restoreDockIcon;
- (IBAction)terminate:(id)sender;
- (void)setAllMenuItems;
- (void)beginFade;
- (void)fadeOut:(NSTimer *)timer;
- (void)fadeIn:(NSTimer *)theTimer;

- (void)loadPrefs;
- (void)savePrefs;
- (IBAction)openPrefsWindow:(id)sender;

- (void)setLEDcolors;
- (void)setWindowLevel;
- (void)setWindowStyle;
- (void)setWindowShadow;
- (void)setNeverHide;
- (void)setDockIcon;

- (void)setWindowColorMenuItem;
- (void)set24HourMenuItem;
- (void)setWindowLevelMenuItem;
- (void)setWindowStyleMenuItem;
- (void)setWindowShadowMenuItem;
- (void)setNeverHideMenuItem;
- (void)setDockIconShitMenuItem;

- (IBAction)handle24hour:(id)sender;
- (IBAction)handleClockColor:(id)sender;
- (IBAction)handleWindowLevel:(id)sender;
- (IBAction)handleWindowStyle:(id)sender;
- (IBAction)toggleWindowShadow:(id)sender;
- (IBAction)toggleNeverHide:(id)sender;
- (IBAction)toggleDockIconShit:(id)sender;

- (IBAction)switchClockColor:(id)sender;
- (IBAction)switchWindowLevel:(id)sender;
- (IBAction)switchWindowStyle:(id)sender;
- (IBAction)switchWindowShadow:(id)sender;
- (IBAction)switchNeverHide:(id)sender;
- (IBAction)switchDockIconShit:(id)sender;

- (IBAction)eatPaste:(id)sender;

- (void)setDockIconImage;

- (void)initClocken;
- (void)getCurrentTime:(NSTimer *)timer;

- (void)setHourFirst:(int)h;
- (void)setHourSecond:(int)h;

- (void)setMinuteFirst:(int)m;
- (void)setMinuteSecond:(int)m;

- (void)setSecondFirst:(int)s;
- (void)setSecondSecond:(int)s;

@end
