/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;

public abstract class SerializationResult<T> {
    private final T object;

    private SerializationResult(T object) {
        this.object = object;
    }

    public abstract <S> SerializationResult<S> with(S var1);

    @Nullable
    public abstract ListenableFuture<Void> getFutureToBlockWritesOn();

    public T getObject() {
        return this.object;
    }

    static <T> SerializationResult<T> create(T object, @Nullable ListenableFuture<Void> futureToBlockWritesOn) {
        return futureToBlockWritesOn != null ? new ObjectWithFuture<T>(object, futureToBlockWritesOn) : SerializationResult.createWithoutFuture(object);
    }

    public static <T> SerializationResult<T> createWithoutFuture(T object) {
        return new ObjectWithoutFuture<T>(object);
    }

    private static class ObjectWithFuture<T>
    extends SerializationResult<T> {
        private final ListenableFuture<Void> futureToBlockWritesOn;

        ObjectWithFuture(T obj, @Nullable ListenableFuture<Void> futureToBlockWritesOn) {
            super(obj);
            this.futureToBlockWritesOn = (ListenableFuture)Preconditions.checkNotNull(futureToBlockWritesOn, obj);
        }

        @Override
        public <S> SerializationResult<S> with(S newObj) {
            return new ObjectWithFuture<S>(newObj, this.futureToBlockWritesOn);
        }

        @Override
        public ListenableFuture<Void> getFutureToBlockWritesOn() {
            return this.futureToBlockWritesOn;
        }
    }

    private static class ObjectWithoutFuture<T>
    extends SerializationResult<T> {
        ObjectWithoutFuture(T obj) {
            super(obj);
        }

        @Override
        public <S> SerializationResult<S> with(S newObj) {
            return new ObjectWithoutFuture<S>(newObj);
        }

        @Override
        public ListenableFuture<Void> getFutureToBlockWritesOn() {
            return null;
        }
    }
}

