/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeParameterNaming;
import com.google.errorprone.bugpatterns.TypeParameterShadowing;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@BugPattern(name="TypeNameShadowing", summary="Type parameter declaration shadows another named type", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class TypeNameShadowing
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getTypeParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.findShadowedTypes(tree, tree.getTypeParameters(), state);
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getTypeParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.findShadowedTypes(tree, tree.getTypeParameters(), state);
    }

    private static Iterable<Symbol> typesInEnclosingScope(Env<AttrContext> env, Symbol.PackageSymbol javaLang) {
        ImmutableList localSymbolsInScope = (ImmutableList)Streams.stream(env).map(ctx -> ctx.tree.getTag() == JCTree.Tag.CLASSDEF ? ((Symbol.ClassSymbol)ASTHelpers.getSymbol((Tree)ctx.tree)).members().getSymbols() : ((AttrContext)ctx.info).getLocalElements()).flatMap(symbols -> Streams.stream((Iterable)symbols).filter(sym -> sym instanceof Symbol.TypeSymbol && !(sym instanceof Symbol.TypeVariableSymbol))).collect(ImmutableList.toImmutableList());
        return Iterables.concat((Iterable)localSymbolsInScope, env.toplevel.namedImportScope.getSymbols(), javaLang.members().getSymbols(), env.toplevel.packge.members().getSymbols());
    }

    private Description findShadowedTypes(Tree tree, List<? extends TypeParameterTree> typeParameters, VisitorState state) {
        Env<AttrContext> env = Enter.instance(state.context).getEnv(ASTHelpers.getSymbol((ClassTree)((ClassTree)state.findEnclosing(new Class[]{ClassTree.class}))));
        Symtab symtab = state.getSymtab();
        Symbol.PackageSymbol javaLang = symtab.enterPackage(symtab.java_base, state.getNames().java_lang);
        Iterable<Symbol> enclosingTypes = TypeNameShadowing.typesInEnclosingScope(env, javaLang);
        ImmutableList shadowedTypes = (ImmutableList)typeParameters.stream().map(param -> (Symbol)Iterables.tryFind((Iterable)enclosingTypes, sym -> sym.getSimpleName().equals(ASTHelpers.getType((Tree)param).tsym.getSimpleName())).orNull()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (shadowedTypes.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder descBuilder = this.buildDescription(tree);
        descBuilder.setMessage(TypeNameShadowing.buildMessage((List<Symbol>)shadowedTypes));
        ImmutableSet visibleNames = (ImmutableSet)Streams.stream((Iterable)Iterables.concat(((AttrContext)env.info).getLocalElements(), enclosingTypes)).map(sym -> sym.getSimpleName().toString()).collect(ImmutableSet.toImmutableSet());
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        shadowedTypes.stream().filter(tv -> TypeParameterNaming.TypeParameterNamingClassification.classify(tv.name.toString()).isValidName()).map(tv -> SuggestedFixes.renameTypeParameter((TypeParameterTree)TypeParameterShadowing.typeParameterInList(typeParameters, tv), (Tree)tree, (String)TypeParameterShadowing.replacementTypeVarName(tv.name, (Set<String>)visibleNames), (VisitorState)state)).forEach(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        descBuilder.addFix((Fix)fixBuilder.build());
        return descBuilder.build();
    }

    private static String buildMessage(List<Symbol> shadowedTypes) {
        return "Found type parameters shadowing other declared types:\n\t" + shadowedTypes.stream().map(sym -> "Type parameter " + sym.getSimpleName() + " shadows visible type " + sym.flatName()).collect(Collectors.joining("\n\t"));
    }
}

