/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(name="ConstantPatternCompile", summary="Variables initialized with Pattern#compile calls on constants can be constants", severity=BugPattern.SeverityLevel.WARNING)
public final class ConstantPatternCompile
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> PATTERN_COMPILE_CHECK = Matchers.staticMethod().onClassAny(new String[]{"java.util.regex.Pattern"}).named("compile");
    private static final Matcher<ExpressionTree> MATCHER_MATCHER = Matchers.instanceMethod().onExactClassAny(new String[]{"java.util.regex.Pattern"}).named("matcher");

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        ExpressionTree initializer = tree.getInitializer();
        if (!PATTERN_COMPILE_CHECK.matches((Tree)initializer, state)) {
            return Description.NO_MATCH;
        }
        if (!((MethodInvocationTree)initializer).getArguments().stream().allMatch(ConstantPatternCompile::isArgStaticAndConstant)) {
            return Description.NO_MATCH;
        }
        MethodTree outerMethodTree = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        if (outerMethodTree == null) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        switch (((Symbol)sym).getKind()) {
            case RESOURCE_VARIABLE: {
                return this.describeMatch(tree);
            }
            case LOCAL_VARIABLE: {
                SuggestedFix fix = ConstantPatternCompile.fixLocal(tree, outerMethodTree, state);
                return this.describeMatch(tree, (Fix)fix);
            }
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix fixLocal(VariableTree tree, MethodTree outerMethodTree, VisitorState state) {
        SuggestedFix fix = ConstantPatternCompile.replaceRegexConstant(tree, state);
        if (!fix.isEmpty()) {
            return fix;
        }
        String name = ConstantPatternCompile.inferName(tree, state);
        if (name == null) {
            return SuggestedFix.emptyFix();
        }
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)outerMethodTree);
        boolean canUseStatic = methodSymbol != null && methodSymbol.owner.enclClass().getNestingKind() == NestingKind.TOP_LEVEL || outerMethodTree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        String replacement = String.format("private %s final %s %s = %s;", canUseStatic ? "static " : "", state.getSourceForNode(tree.getType()), name, state.getSourceForNode((Tree)tree.getInitializer()));
        return SuggestedFix.builder().merge(SuggestedFixes.renameVariableUsages((VariableTree)tree, (String)name, (VisitorState)state)).postfixWith((Tree)outerMethodTree, replacement).delete((Tree)tree).build();
    }

    private static SuggestedFix replaceRegexConstant(VariableTree tree, VisitorState state) {
        ExpressionTree regex = ((MethodInvocationTree)tree.getInitializer()).getArguments().get(0);
        final Symbol regexSym = ASTHelpers.getSymbol((Tree)regex);
        if (!(regexSym != null && regexSym.getKind().equals((Object)ElementKind.FIELD) && regexSym.isStatic() && regexSym.getModifiers().contains((Object)Modifier.FINAL) && ConstantPatternCompile.isSelfOrTransitiveOwnerPrivate(regexSym))) {
            return SuggestedFix.emptyFix();
        }
        final VariableTree[] defs = new VariableTree[]{null};
        final int[] uses = new int[]{0};
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                if (regexSym.equals(ASTHelpers.getSymbol((VariableTree)tree))) {
                    defs[0] = tree;
                }
                return (Void)super.visitVariable(tree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (regexSym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    uses[0] = uses[0] + 1;
                }
                return (Void)super.visitIdentifier(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                if (regexSym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    uses[0] = uses[0] + 1;
                }
                return (Void)super.visitMemberSelect(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        if (uses[0] != 1) {
            return SuggestedFix.emptyFix();
        }
        VariableTree def = defs[0];
        return SuggestedFix.builder().replace(def.getType(), state.getSourceForNode(tree.getType())).prefixWith((Tree)def.getInitializer(), state.getSourceCode().subSequence(ASTHelpers.getStartPosition((Tree)tree.getInitializer()), ASTHelpers.getStartPosition((Tree)regex)).toString()).postfixWith((Tree)def.getInitializer(), ")").merge(SuggestedFixes.renameVariableUsages((VariableTree)tree, (String)def.getName().toString(), (VisitorState)state)).delete((Tree)tree).build();
    }

    private static boolean isSelfOrTransitiveOwnerPrivate(Symbol sym) {
        while (sym != null) {
            if (sym.isPrivate()) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }

    private static String inferName(VariableTree tree, VisitorState state) {
        String name = ConstantPatternCompile.fromName(tree);
        if (name != null) {
            return name;
        }
        name = ConstantPatternCompile.fromInitializer(tree);
        if (name != null) {
            return name;
        }
        name = ConstantPatternCompile.fromUse(tree, state);
        if (name != null) {
            return name;
        }
        return null;
    }

    private static String fromName(VariableTree tree) {
        String name = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, tree.getName().toString());
        if (name.length() > 1 && !name.equals("PATTERN")) {
            return name;
        }
        return null;
    }

    private static String fromInitializer(VariableTree tree) {
        ExpressionTree regex = ((MethodInvocationTree)tree.getInitializer()).getArguments().get(0);
        if (!(regex instanceof IdentifierTree)) {
            return null;
        }
        String name = ((IdentifierTree)regex).getName().toString();
        if (name.endsWith("_REGEX")) {
            name = name.substring(0, name.length() - "_REGEX".length());
        }
        if (name.endsWith("_PATTERN")) {
            return null;
        }
        return name + "_PATTERN";
    }

    private static String fromUse(VariableTree tree, VisitorState state) {
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        final ImmutableList.Builder usesBuilder = ImmutableList.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    usesBuilder.add((Object)this.getCurrentPath());
                }
                return null;
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        ImmutableList uses = usesBuilder.build();
        if (uses.size() != 1) {
            return null;
        }
        TreePath use = (TreePath)Iterables.getOnlyElement((Iterable)uses);
        Tree grandParent = use.getParentPath().getParentPath().getLeaf();
        if (!(grandParent instanceof ExpressionTree)) {
            return null;
        }
        if (!MATCHER_MATCHER.matches((Tree)((ExpressionTree)grandParent), state)) {
            return null;
        }
        ExpressionTree matchTree = ((MethodInvocationTree)grandParent).getArguments().get(0);
        if (!(matchTree instanceof IdentifierTree)) {
            return null;
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ((IdentifierTree)matchTree).getName().toString()) + "_PATTERN";
    }

    private static boolean isArgStaticAndConstant(ExpressionTree arg) {
        if (ASTHelpers.constValue((Tree)arg) == null) {
            return false;
        }
        Symbol argSymbol = ASTHelpers.getSymbol((Tree)arg);
        if (argSymbol == null) {
            return true;
        }
        return (argSymbol.flags() & 8L) != 0L;
    }
}

