/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.io.Serializable;

@BugPattern(name="CollectionToArraySafeParameter", summary="The type of the array parameter of Collection.toArray needs to be compatible with the array type", severity=BugPattern.SeverityLevel.ERROR)
public class CollectionToArraySafeParameter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> TO_ARRAY_MATCHER = Matchers.instanceMethod().onDescendantOf("java.util.Collection").withSignature("<T>toArray(T[])");
    private static final Supplier<Symbol> JAVA_UTIL_COLLECTION = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("java.util.Collection"));

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
        if (!TO_ARRAY_MATCHER.matches((Tree)methodInvocationTree, visitorState)) {
            return Description.NO_MATCH;
        }
        Types types = visitorState.getTypes();
        Type variableType = types.elemtype(ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(methodInvocationTree.getArguments()))));
        if (variableType == null) {
            return Description.NO_MATCH;
        }
        Type collectionType = types.asSuper(ASTHelpers.getReceiverType((ExpressionTree)methodInvocationTree), (Symbol)JAVA_UTIL_COLLECTION.get(visitorState));
        List<Type> typeArguments = collectionType.getTypeArguments();
        if (!typeArguments.isEmpty() && !types.isCastable(types.erasure(variableType), types.erasure((Type)Iterables.getOnlyElement(typeArguments)))) {
            return this.describeMatch(methodInvocationTree);
        }
        return Description.NO_MATCH;
    }
}

