/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutput;
import com.google.common.io.LineReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SplitSelectTool {
    public static List<String> splitSelect(ProcessExecutor processExecutor, File splitSelectExec, String deviceConfig, String mainApkPath, Collection<String> splitApksPath) throws ProcessException {
        ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
        processBuilder.setExecutable(splitSelectExec);
        processBuilder.addArgs("--target", deviceConfig);
        processBuilder.addArgs("--base", mainApkPath);
        for (String apkPath : splitApksPath) {
            processBuilder.addArgs("--split", apkPath);
        }
        SplitSelectOutputHandler outputHandler = new SplitSelectOutputHandler();
        processExecutor.execute(processBuilder.createProcess(), outputHandler).rethrowFailure().assertNormalExitValue();
        return outputHandler.getResultApks();
    }

    private static class SplitSelectOutputHandler
    extends BaseProcessOutputHandler {
        private final List<String> resultApks = new ArrayList<String>();

        private SplitSelectOutputHandler() {
        }

        public List<String> getResultApks() {
            return this.resultApks;
        }

        @Override
        public void handleOutput(ProcessOutput processOutput) throws ProcessException {
            block5: {
                try {
                    if (processOutput instanceof BaseProcessOutputHandler.BaseProcessOutput) {
                        String stderr;
                        BaseProcessOutputHandler.BaseProcessOutput impl = (BaseProcessOutputHandler.BaseProcessOutput)processOutput;
                        String stdout = impl.getStandardOutputAsString();
                        if (!stdout.isEmpty()) {
                            this.resultApks.addAll(SplitSelectOutputHandler.readLines(stdout));
                        }
                        if (!(stderr = impl.getErrorOutputAsString()).isEmpty()) {
                            throw new RuntimeException("split-select:" + stderr);
                        }
                        break block5;
                    }
                    throw new IllegalArgumentException("processOutput was not created by this handler.");
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception while reading split-select output", e);
                }
            }
        }

        private static List<String> readLines(String input) throws IOException {
            ArrayList<String> result = new ArrayList<String>();
            LineReader lineReader = new LineReader((Readable)new StringReader(input));
            String line = lineReader.readLine();
            while (line != null) {
                result.add(line);
                line = lineReader.readLine();
            }
            return result;
        }
    }
}

