/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(name="ParcelableCreator", summary="Detects classes which implement Parcelable but don't have CREATOR", severity=BugPattern.SeverityLevel.ERROR)
public class ParcelableCreator
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> PARCELABLE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isDirectImplementationOf((String)"android.os.Parcelable"), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT))});
    private static final Matcher<VariableTree> PARCELABLE_CREATOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf((String)"android.os.Parcelable$Creator"), Matchers.hasModifier((Modifier)Modifier.STATIC), Matchers.hasModifier((Modifier)Modifier.PUBLIC)});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!PARCELABLE_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol parcelableCreatorSymbol = state.getSymbolFromString("android.os.Parcelable$Creator");
        if (parcelableCreatorSymbol == null) {
            return Description.NO_MATCH;
        }
        Type.ClassType classType = ASTHelpers.getType((ClassTree)tree);
        for (Tree tree2 : tree.getMembers()) {
            VariableTree variableTree;
            if (tree2.getKind() != Tree.Kind.VARIABLE || !PARCELABLE_CREATOR_MATCHER.matches((Tree)(variableTree = (VariableTree)tree2), state) || !ParcelableCreator.isVariableClassCreator(variableTree, state, classType, parcelableCreatorSymbol)) continue;
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean isVariableClassCreator(VariableTree variableTree, VisitorState state, Type.ClassType classType, Symbol parcelableCreatorSymbol) {
        Tree typeTree = variableTree.getType();
        Type type = ASTHelpers.getType((Tree)typeTree);
        Types types = state.getTypes();
        Type superType = types.asSuper(type, parcelableCreatorSymbol);
        if (superType == null) {
            return false;
        }
        List<Type> typeArguments = superType.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return true;
        }
        return ASTHelpers.isSubtype((Type)classType, (Type)((Type)Iterables.getOnlyElement(typeArguments)), (VisitorState)state);
    }
}

