/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.AutoValue_Binder_Statistics;
import com.google.turbine.binder.CanonicalTypeBinder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.CompUnitPreprocessor;
import com.google.turbine.binder.ConstBinder;
import com.google.turbine.binder.ConstEvaluator;
import com.google.turbine.binder.DisambiguateTypeAnnotations;
import com.google.turbine.binder.HierarchyBinder;
import com.google.turbine.binder.ModuleBinder;
import com.google.turbine.binder.Processing;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.TypeBinder;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bound.PackageSourceBoundClass;
import com.google.turbine.binder.bound.PackageSourceBoundModule;
import com.google.turbine.binder.bound.SourceBoundClass;
import com.google.turbine.binder.bound.SourceHeaderBoundClass;
import com.google.turbine.binder.bound.SourceModuleInfo;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.LazyEnv;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.CompoundTopLevelIndex;
import com.google.turbine.binder.lookup.ImportIndex;
import com.google.turbine.binder.lookup.ImportScope;
import com.google.turbine.binder.lookup.MemberImportIndex;
import com.google.turbine.binder.lookup.PackageScope;
import com.google.turbine.binder.lookup.SimpleTopLevelIndex;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.lookup.WildImportIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineDiagnostic;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.model.Const;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.time.Duration;
import java.util.Optional;

public final class Binder {
    public static BindingResult bind(ImmutableList<Tree.CompUnit> units, ClassPath classpath, ClassPath bootclasspath, Optional<String> moduleVersion) {
        return Binder.bind(units, classpath, Processing.ProcessorInfo.empty(), bootclasspath, moduleVersion);
    }

    public static BindingResult bind(ImmutableList<Tree.CompUnit> units, ClassPath classpath, Processing.ProcessorInfo processorInfo, ClassPath bootclasspath, Optional<String> moduleVersion) {
        BindingResult br;
        TurbineLog log = new TurbineLog();
        try {
            br = Binder.bind(log, units, (ImmutableMap<String, SourceFile>)ImmutableMap.of(), (ImmutableMap<String, byte[]>)ImmutableMap.of(), classpath, bootclasspath, moduleVersion);
            if (!processorInfo.processors().isEmpty() && !units.isEmpty()) {
                br = Processing.process(log, units, classpath, processorInfo, bootclasspath, br, moduleVersion);
            }
        }
        catch (TurbineError turbineError) {
            throw new TurbineError((ImmutableList<TurbineDiagnostic>)ImmutableList.builder().addAll(log.diagnostics()).addAll(turbineError.diagnostics()).build());
        }
        log.maybeThrow();
        return br;
    }

    static BindingResult bind(TurbineLog log, ImmutableList<Tree.CompUnit> units, ImmutableMap<String, SourceFile> generatedSources, ImmutableMap<String, byte[]> generatedClasses, ClassPath classpath, ClassPath bootclasspath, Optional<String> moduleVersion) {
        ImmutableList<CompUnitPreprocessor.PreprocessedCompUnit> preProcessedUnits = CompUnitPreprocessor.preprocess(units);
        SimpleEnv<ClassSymbol, SourceBoundClass> ienv = Binder.bindSourceBoundClasses(preProcessedUnits);
        ImmutableSet syms = ienv.asMap().keySet();
        CompoundTopLevelIndex tli = CompoundTopLevelIndex.of(SimpleTopLevelIndex.of((Iterable<ClassSymbol>)ienv.asMap().keySet()), bootclasspath.index(), classpath.index());
        CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv = CompoundEnv.of(classpath.env()).append(bootclasspath.env());
        CompoundEnv<ModuleSymbol, ModuleInfo> classPathModuleEnv = CompoundEnv.of(classpath.moduleEnv()).append(bootclasspath.moduleEnv());
        BindPackagesResult bindPackagesResult = Binder.bindPackages(log, ienv, tli, preProcessedUnits, classPathEnv);
        SimpleEnv<ClassSymbol, PackageSourceBoundClass> psenv = bindPackagesResult.classes;
        SimpleEnv<ModuleSymbol, PackageSourceBoundModule> modules = bindPackagesResult.modules;
        Env<ClassSymbol, SourceHeaderBoundClass> henv = Binder.bindHierarchy(log, (Iterable<ClassSymbol>)syms, psenv, classPathEnv);
        Env<ClassSymbol, SourceTypeBoundClass> tenv = Binder.bindTypes(log, (ImmutableSet<ClassSymbol>)syms, henv, CompoundEnv.of(classPathEnv).append(henv));
        tenv = Binder.constants((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv), log);
        tenv = Binder.disambiguateTypeAnnotations((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        tenv = Binder.canonicalizeTypes((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        ImmutableList<SourceModuleInfo> boundModules = Binder.bindModules(modules, CompoundEnv.of(classPathEnv).append(tenv), classPathModuleEnv, moduleVersion, log);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ClassSymbol sym : syms) {
            result.put((Object)sym, (Object)tenv.get(sym));
        }
        return new BindingResult((ImmutableMap<ClassSymbol, SourceTypeBoundClass>)result.build(), boundModules, classPathEnv, tli, generatedSources, generatedClasses, Statistics.empty());
    }

    static SimpleEnv<ClassSymbol, SourceBoundClass> bindSourceBoundClasses(ImmutableList<CompUnitPreprocessor.PreprocessedCompUnit> units) {
        SimpleEnv.Builder<ClassSymbol, SourceBoundClass> envBuilder = SimpleEnv.builder();
        for (CompUnitPreprocessor.PreprocessedCompUnit unit : units) {
            for (SourceBoundClass type : unit.types()) {
                SourceBoundClass prev = envBuilder.put(type.sym(), type);
                if (prev == null) continue;
                throw TurbineError.format(unit.source(), type.decl().position(), TurbineError.ErrorKind.DUPLICATE_DECLARATION, type.sym());
            }
        }
        return envBuilder.build();
    }

    private static BindPackagesResult bindPackages(TurbineLog log, Env<ClassSymbol, SourceBoundClass> ienv, TopLevelIndex tli, ImmutableList<CompUnitPreprocessor.PreprocessedCompUnit> units, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
        SimpleEnv.Builder<ClassSymbol, PackageSourceBoundClass> env = SimpleEnv.builder();
        SimpleEnv.Builder<ModuleSymbol, PackageSourceBoundModule> modules = SimpleEnv.builder();
        PackageScope javaLang = tli.lookupPackage((Iterable<String>)ImmutableList.of((Object)"java", (Object)"lang"));
        if (javaLang == null) {
            throw new IllegalArgumentException("Could not find java.lang on bootclasspath");
        }
        CompoundScope topLevel = CompoundScope.base(tli.scope()).append(javaLang);
        for (CompUnitPreprocessor.PreprocessedCompUnit unit : units) {
            ImmutableList packagename = ImmutableList.copyOf((Iterable)Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)unit.packageName()));
            PackageScope packageScope = tli.lookupPackage((Iterable<String>)packagename);
            Resolve.CanonicalResolver importResolver = new Resolve.CanonicalResolver(unit.packageName(), CompoundEnv.of(classPathEnv).append(ienv));
            ImportIndex importScope = ImportIndex.create(log.withSource(unit.source()), importResolver, tli, unit.imports());
            WildImportIndex wildImportScope = WildImportIndex.create(importResolver, tli, unit.imports());
            MemberImportIndex memberImports = new MemberImportIndex(unit.source(), importResolver, tli, unit.imports());
            ImportScope scope = ImportScope.fromScope(topLevel).append(wildImportScope).append(ImportScope.fromScope(packageScope)).append(importScope);
            if (unit.module().isPresent()) {
                Tree.ModDecl module = unit.module().get();
                modules.put(new ModuleSymbol(module.moduleName()), new PackageSourceBoundModule(module, scope, memberImports, unit.source()));
            }
            for (SourceBoundClass type : unit.types()) {
                env.put(type.sym(), new PackageSourceBoundClass(type, scope, memberImports, unit.source()));
            }
        }
        return new BindPackagesResult(env.build(), modules.build());
    }

    private static Env<ClassSymbol, SourceHeaderBoundClass> bindHierarchy(final TurbineLog log, Iterable<ClassSymbol> syms, final SimpleEnv<ClassSymbol, PackageSourceBoundClass> psenv, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
        ImmutableMap.Builder completers = ImmutableMap.builder();
        for (ClassSymbol sym : syms) {
            completers.put((Object)sym, (Object)new LazyEnv.Completer<ClassSymbol, HeaderBoundClass, SourceHeaderBoundClass>(){

                @Override
                public SourceHeaderBoundClass complete(Env<ClassSymbol, HeaderBoundClass> henv, ClassSymbol sym) {
                    PackageSourceBoundClass base = (PackageSourceBoundClass)psenv.get(sym);
                    return HierarchyBinder.bind(log.withSource(base.source()), sym, base, henv);
                }
            });
        }
        return new LazyEnv(completers.build(), classPathEnv);
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> bindTypes(TurbineLog log, ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceHeaderBoundClass> shenv, Env<ClassSymbol, HeaderBoundClass> henv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            SourceHeaderBoundClass base = shenv.get(sym);
            builder.put(sym, TypeBinder.bind(log.withSource(base.source()), henv, sym, base));
        }
        return builder.build();
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> canonicalizeTypes(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> stenv, Env<ClassSymbol, TypeBoundClass> tenv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.put(sym, CanonicalTypeBinder.bind(sym, stenv.get(sym), tenv));
        }
        return builder.build();
    }

    private static ImmutableList<SourceModuleInfo> bindModules(final SimpleEnv<ModuleSymbol, PackageSourceBoundModule> modules, CompoundEnv<ClassSymbol, TypeBoundClass> env, CompoundEnv<ModuleSymbol, ModuleInfo> moduleEnv, final Optional<String> moduleVersion, TurbineLog log) {
        moduleEnv = moduleEnv.append(new Env<ModuleSymbol, ModuleInfo>(){

            @Override
            public ModuleInfo get(ModuleSymbol sym) {
                PackageSourceBoundModule info = (PackageSourceBoundModule)modules.get(sym);
                if (info != null) {
                    return new ModuleInfo(info.module().moduleName(), moduleVersion.orElse(null), 0, (ImmutableList<AnnoInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.RequireInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ExportInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.OpenInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.UseInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ProvideInfo>)ImmutableList.of());
                }
                return null;
            }
        });
        ImmutableList.Builder bound = ImmutableList.builder();
        for (PackageSourceBoundModule module : modules.asMap().values()) {
            bound.add((Object)ModuleBinder.bind(module, env, moduleEnv, moduleVersion, log.withSource(module.source())));
        }
        return bound.build();
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> constants(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> env, final CompoundEnv<ClassSymbol, TypeBoundClass> baseEnv, final TurbineLog log) {
        ImmutableMap.Builder completers = ImmutableMap.builder();
        for (final ClassSymbol sym : syms) {
            final SourceTypeBoundClass info = env.get(sym);
            for (final TypeBoundClass.FieldInfo field : info.fields()) {
                if (!Binder.isConst(field)) continue;
                completers.put((Object)field.sym(), (Object)new LazyEnv.Completer<FieldSymbol, Const.Value, Const.Value>(){

                    @Override
                    public Const.Value complete(Env<FieldSymbol, Const.Value> env1, FieldSymbol k) {
                        try {
                            return new ConstEvaluator(sym, sym, info.memberImports(), info.source(), info.scope(), env1, baseEnv, log.withSource(info.source())).evalFieldInitializer(field.decl().init().get(), field.type());
                        }
                        catch (LazyEnv.LazyBindingError e) {
                            return null;
                        }
                    }
                });
            }
        }
        LazyEnv constenv = new LazyEnv(completers.build(), SimpleEnv.builder().build());
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            SourceTypeBoundClass base = env.get(sym);
            builder.put(sym, new ConstBinder(constenv, sym, baseEnv, base, log.withSource(base.source())).bind());
        }
        return builder.build();
    }

    static boolean isConst(TypeBoundClass.FieldInfo field) {
        if ((field.access() & 0x10) == 0) {
            return false;
        }
        if (field.decl() == null) {
            return false;
        }
        Optional<Tree.Expression> init = field.decl().init();
        if (!init.isPresent()) {
            return false;
        }
        switch (field.type().tyKind()) {
            case PRIM_TY: {
                break;
            }
            case CLASS_TY: {
                if (((Type.ClassTy)field.type()).sym().equals(ClassSymbol.STRING)) break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> disambiguateTypeAnnotations(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> stenv, Env<ClassSymbol, TypeBoundClass> tenv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.put(sym, DisambiguateTypeAnnotations.bind(stenv.get(sym), tenv));
        }
        return builder.build();
    }

    private Binder() {
    }

    public static class BindingResult {
        private final ImmutableMap<ClassSymbol, SourceTypeBoundClass> units;
        private final ImmutableList<SourceModuleInfo> modules;
        private final CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv;
        private final TopLevelIndex tli;
        private final ImmutableMap<String, SourceFile> generatedSources;
        private final ImmutableMap<String, byte[]> generatedClasses;
        private final Statistics statistics;

        public BindingResult(ImmutableMap<ClassSymbol, SourceTypeBoundClass> units, ImmutableList<SourceModuleInfo> modules, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv, TopLevelIndex tli, ImmutableMap<String, SourceFile> generatedSources, ImmutableMap<String, byte[]> generatedClasses, Statistics statistics) {
            this.units = units;
            this.modules = modules;
            this.classPathEnv = classPathEnv;
            this.tli = tli;
            this.generatedSources = generatedSources;
            this.generatedClasses = generatedClasses;
            this.statistics = statistics;
        }

        public ImmutableMap<ClassSymbol, SourceTypeBoundClass> units() {
            return this.units;
        }

        public ImmutableList<SourceModuleInfo> modules() {
            return this.modules;
        }

        public CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv() {
            return this.classPathEnv;
        }

        public TopLevelIndex tli() {
            return this.tli;
        }

        public ImmutableMap<String, SourceFile> generatedSources() {
            return this.generatedSources;
        }

        public ImmutableMap<String, byte[]> generatedClasses() {
            return this.generatedClasses;
        }

        public Statistics statistics() {
            return this.statistics;
        }

        public BindingResult withGeneratedClasses(ImmutableMap<String, byte[]> generatedClasses) {
            return new BindingResult(this.units, this.modules, this.classPathEnv, this.tli, this.generatedSources, generatedClasses, this.statistics);
        }

        public BindingResult withGeneratedSources(ImmutableMap<String, SourceFile> generatedSources) {
            return new BindingResult(this.units, this.modules, this.classPathEnv, this.tli, generatedSources, this.generatedClasses, this.statistics);
        }

        public BindingResult withStatistics(Statistics statistics) {
            return new BindingResult(this.units, this.modules, this.classPathEnv, this.tli, this.generatedSources, this.generatedClasses, statistics);
        }
    }

    @AutoValue
    public static abstract class Statistics {
        public abstract ImmutableMap<String, Duration> processingTime();

        public abstract ImmutableMap<String, byte[]> processorMetrics();

        public static Statistics create(ImmutableMap<String, Duration> processingTime, ImmutableMap<String, byte[]> processorMetrics) {
            return new AutoValue_Binder_Statistics(processingTime, processorMetrics);
        }

        public static Statistics empty() {
            return Statistics.create((ImmutableMap<String, Duration>)ImmutableMap.of(), (ImmutableMap<String, byte[]>)ImmutableMap.of());
        }
    }

    static class BindPackagesResult {
        final SimpleEnv<ClassSymbol, PackageSourceBoundClass> classes;
        final SimpleEnv<ModuleSymbol, PackageSourceBoundModule> modules;

        BindPackagesResult(SimpleEnv<ClassSymbol, PackageSourceBoundClass> classes, SimpleEnv<ModuleSymbol, PackageSourceBoundModule> modules) {
            this.classes = classes;
            this.modules = modules;
        }
    }
}

