/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ExecutionRecord;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.ProcessRecorder;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadRecorder
implements Recorder {
    private static final Logger logger = Logger.getLogger(ThreadRecorder.class.getName());
    protected static final Recorder dummyRecorder = new Recorder(){

        @Override
        public <T> T record(ExecutionType executionType, Recorder.Block<T> block, Recorder.Property ... properties) {
            return this.record(executionType, block, Collections.<Recorder.Property>emptyList());
        }

        @Override
        public <T> T record(ExecutionType executionType, Recorder.Block<T> block, List<Recorder.Property> properties) {
            try {
                return (T)block.call();
            }
            catch (Exception e) {
                block.handleException(e);
                return null;
            }
        }

        @Override
        public long allocationRecordId() {
            return 0L;
        }

        @Override
        public void closeRecord(ExecutionRecord record) {
        }
    };
    private static final Recorder recorder = new ThreadRecorder();
    protected final ThreadLocal<Deque<Long>> recordStacks = new ThreadLocal<Deque<Long>>(){

        @Override
        protected Deque<Long> initialValue() {
            return new ArrayDeque<Long>();
        }
    };

    public static Recorder get() {
        return ProcessRecorderFactory.getFactory().isInitialized() ? recorder : dummyRecorder;
    }

    @Override
    public long allocationRecordId() {
        long recordId = ProcessRecorder.allocateRecordId();
        this.recordStacks.get().push(recordId);
        return recordId;
    }

    @Override
    public void closeRecord(ExecutionRecord executionRecord) {
        if (this.recordStacks.get().pop() != executionRecord.id) {
            logger.severe("Internal Error : mixed records in profiling stack");
        }
        ProcessRecorder.get().writeRecord(executionRecord);
    }

    @Override
    public <T> T record(ExecutionType executionType, Recorder.Block<T> block, Recorder.Property ... properties) {
        ImmutableList propertyList = properties == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])properties);
        return this.record(executionType, block, (List<Recorder.Property>)propertyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(ExecutionType executionType, Recorder.Block<T> block, List<Recorder.Property> properties) {
        long thisRecordId = ProcessRecorder.allocateRecordId();
        Long parentId = this.recordStacks.get().peek();
        long startTimeInMs = System.currentTimeMillis();
        PartialRecord currentRecord = new PartialRecord(executionType, thisRecordId, parentId == null ? 0L : parentId, startTimeInMs, properties);
        this.recordStacks.get().push(thisRecordId);
        try {
            Object v = block.call();
            return (T)v;
        }
        catch (Exception e) {
            block.handleException(e);
        }
        finally {
            if (this.recordStacks.get().pop() != currentRecord.recordId) {
                logger.log(Level.SEVERE, "Profiler stack corrupted");
            }
            ProcessRecorder.get().writeRecord(new ExecutionRecord(currentRecord.recordId, currentRecord.parentRecordId, currentRecord.startTimeInMs, System.currentTimeMillis() - currentRecord.startTimeInMs, currentRecord.executionType, currentRecord.extraArgs));
        }
        return null;
    }

    private static class PartialRecord {
        final ExecutionType executionType;
        final long recordId;
        final long parentRecordId;
        final long startTimeInMs;
        final List<Recorder.Property> extraArgs;

        PartialRecord(ExecutionType executionType, long recordId, long parentId, long startTimeInMs, List<Recorder.Property> extraArgs) {
            this.executionType = executionType;
            this.recordId = recordId;
            this.parentRecordId = parentId;
            this.startTimeInMs = startTimeInMs;
            this.extraArgs = extraArgs;
        }
    }
}

