/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.threeten.extra.AmPm;
import org.threeten.extra.DayOfMonth;
import org.threeten.extra.DayOfYear;
import org.threeten.extra.Quarter;
import org.threeten.extra.YearQuarter;
import org.threeten.extra.YearWeek;

@BugPattern(name="FromTemporalAccessor", summary="Certain combinations of javaTimeType.from(TemporalAccessor) will always throw a DateTimeException or return the parameter directly.", explanation="Not all java.time types can be created via from(TemporalAccessor). For example, you can create a Month from a LocalDate (Month.from(localDate)) because a LocalDate consists of a year, month, and day. However, you cannot create a LocalDate from a Month (since it doesn't have the year or day information). Instead of throwing a DateTimeException at runtime, this checker validates the type transformations at compile time using static type information.", severity=BugPattern.SeverityLevel.ERROR)
public final class FromTemporalAccessor
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String TEMPORAL_ACCESSOR = "java.time.temporal.TemporalAccessor";
    private static final Matcher<ExpressionTree> FROM_MATCHER = Matchers.staticMethod().anyClass().named("from").withParameters(new String[]{"java.time.temporal.TemporalAccessor"});
    private static final Matcher<ExpressionTree> PACKAGE_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.packageStartsWith((String)"java.time"), Matchers.packageStartsWith((String)"org.threeten.extra"), Matchers.packageStartsWith((String)"tck.java.time")});
    private static final ImmutableListMultimap<Matcher<Tree>, Matcher<ExpressionTree>> BAD_VALUE_FROM_KEY = new ImmutableListMultimap.Builder().putAll(FromTemporalAccessor.makeKey(DayOfWeek.class), FromTemporalAccessor.makeValues(Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(Instant.class), FromTemporalAccessor.makeValues(DayOfWeek.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(LocalDate.class), FromTemporalAccessor.makeValues(Instant.class, LocalDateTime.class, LocalTime.class, OffsetDateTime.class, OffsetTime.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class)).putAll(FromTemporalAccessor.makeKey(LocalDateTime.class), FromTemporalAccessor.makeValues(Instant.class, OffsetDateTime.class, OffsetTime.class, ZonedDateTime.class, ZoneOffset.class)).putAll(FromTemporalAccessor.makeKey(LocalTime.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(Month.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(MonthDay.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfYear.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(OffsetDateTime.class), FromTemporalAccessor.makeValues(new Class[0])).putAll(FromTemporalAccessor.makeKey(OffsetTime.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, Month.class, MonthDay.class, OffsetDateTime.class, Year.class, YearMonth.class, ZonedDateTime.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(Year.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(YearMonth.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(ZonedDateTime.class), FromTemporalAccessor.makeValues(new Class[0])).putAll(FromTemporalAccessor.makeKey(ZoneOffset.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, AmPm.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(AmPm.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(DayOfMonth.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfYear.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(DayOfYear.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, Quarter.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(Quarter.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, YearQuarter.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(YearQuarter.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, YearWeek.class)).putAll(FromTemporalAccessor.makeKey(YearWeek.class), FromTemporalAccessor.makeValues(DayOfWeek.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneOffset.class, AmPm.class, DayOfMonth.class, DayOfYear.class, Quarter.class, YearQuarter.class)).build();

    private static Matcher<Tree> makeKey(Class<?> keyClass) {
        return Matchers.isSameType((String)keyClass.getName());
    }

    private static List<Matcher<ExpressionTree>> makeValues(Class<?> ... values) {
        ArrayList<Matcher<ExpressionTree>> entries = new ArrayList<Matcher<ExpressionTree>>();
        for (Class<?> value : values) {
            entries.add((Matcher<ExpressionTree>)Matchers.staticMethod().onClass(value.getName()).named("from").withParameters(new String[]{TEMPORAL_ACCESSOR}));
        }
        return entries;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FROM_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (PACKAGE_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree).toString();
        if (!receiverType.startsWith("java.time") && !receiverType.startsWith("org.threeten.extra")) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg0 = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        Type type0 = ASTHelpers.getType((Tree)arg0);
        if (ASTHelpers.isSameType((Type)type0, (Type)state.getTypeFromString(TEMPORAL_ACCESSOR), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)type0, (VisitorState)state)) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            builder.replace((Tree)tree, state.getSourceForNode((Tree)arg0));
            return this.describeMatch(tree, (Fix)builder.build());
        }
        for (Map.Entry entry : BAD_VALUE_FROM_KEY.entries()) {
            Matcher fromMatcher = (Matcher)entry.getValue();
            Matcher argumentMatcher = (Matcher)entry.getKey();
            if (!fromMatcher.matches((Tree)tree, state) || !argumentMatcher.matches((Tree)arg0, state)) continue;
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

