/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypesWithUndefinedEquality;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.ContainmentMatchers;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Arrays;

@BugPattern(name="CollectionUndefinedEquality", summary="This type does not have well-defined equals behavior.", tags={"FragileCode"}, severity=BugPattern.SeverityLevel.WARNING)
public final class CollectionUndefinedEquality
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final Matcher<ExpressionTree> TYPES_NOT_DEPENDING_ON_OBJECT_EQUALITY = Matchers.anyMethod().onClass(TypePredicates.isDescendantOfAny((Iterable)ImmutableList.of((Object)"java.util.IdentityHashMap", (Object)"java.util.IdentityHashSet", (Object)"java.util.SortedMap", (Object)"java.util.SortedSet")));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description match(ExpressionTree tree, VisitorState state) {
        AbstractCollectionIncompatibleTypeMatcher.MatchResult result = ContainmentMatchers.firstNonNullMatchResult(tree, state);
        if (result == null) {
            return Description.NO_MATCH;
        }
        if (TYPES_NOT_DEPENDING_ON_OBJECT_EQUALITY.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return Arrays.stream(TypesWithUndefinedEquality.values()).filter(b -> b.matchesType(result.sourceType(), state) || b.matchesType(result.targetType(), state)).findFirst().map(b -> this.buildDescription(tree).setMessage(b.shortName() + " does not have well-defined equals behavior.").build()).orElse(Description.NO_MATCH);
    }
}

